/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.BasicNonoSubscriber;
import hu.akarnokd.rxjava3.basetypes.Nono;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import java.util.Objects;
import org.reactivestreams.Subscriber;

final class NonoMapError
extends Nono {
    final Nono source;
    final Function<? super Throwable, ? extends Throwable> mapper;

    NonoMapError(Nono source, Function<? super Throwable, ? extends Throwable> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        this.source.subscribe(new MapErrorSubscriber(s, this.mapper));
    }

    static final class MapErrorSubscriber
    extends BasicNonoSubscriber {
        final Function<? super Throwable, ? extends Throwable> mapper;

        MapErrorSubscriber(Subscriber<? super Void> downstream, Function<? super Throwable, ? extends Throwable> mapper) {
            super(downstream);
            this.mapper = mapper;
        }

        public void onError(Throwable t) {
            Throwable ex;
            try {
                ex = (Throwable)Objects.requireNonNull(this.mapper.apply((Object)t), "The mapper returned a null Throwable");
            }
            catch (Throwable exc) {
                Exceptions.throwIfFatal((Throwable)exc);
                ex = new CompositeException(new Throwable[]{t, exc});
            }
            this.downstream.onError(ex);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

