/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.BasicNonoIntQueueSubscription;
import hu.akarnokd.rxjava3.basetypes.Nono;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class NonoProcessor
extends Nono
implements Processor<Void, Void> {
    static final NonoSubscription[] EMPTY = new NonoSubscription[0];
    static final NonoSubscription[] TERMINATED = new NonoSubscription[0];
    Throwable error;
    final AtomicReference<NonoSubscription[]> subscribers = new AtomicReference<NonoSubscription[]>(EMPTY);
    final AtomicBoolean once = new AtomicBoolean();

    public static NonoProcessor create() {
        return new NonoProcessor();
    }

    NonoProcessor() {
    }

    boolean add(NonoSubscription inner) {
        NonoSubscription[] b;
        NonoSubscription[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new NonoSubscription[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void delete(NonoSubscription inner) {
        NonoSubscription[] b;
        NonoSubscription[] a;
        do {
            int n;
            if ((n = (a = this.subscribers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < a.length; ++i) {
                NonoSubscription ns = a[i];
                if (ns != inner) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new NonoSubscription[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    public void onSubscribe(Subscription s) {
        if (this.subscribers.get() == TERMINATED) {
            s.cancel();
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    public void onNext(Void t) {
        throw new NullPointerException();
    }

    public void onError(Throwable t) {
        if (this.once.compareAndSet(false, true)) {
            if (t == null) {
                t = new NullPointerException();
            }
            this.error = t;
            for (NonoSubscription ns : this.subscribers.getAndSet(TERMINATED)) {
                ns.doError(t);
            }
        } else {
            RxJavaPlugins.onError((Throwable)t);
        }
    }

    public void onComplete() {
        if (this.once.compareAndSet(false, true)) {
            for (NonoSubscription ns : this.subscribers.getAndSet(TERMINATED)) {
                ns.doComplete();
            }
        }
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        NonoSubscription ns = new NonoSubscription(s, this);
        s.onSubscribe((Subscription)ns);
        if (this.add(ns)) {
            if (ns.get() != 0) {
                this.delete(ns);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                ns.doError(ex);
            } else {
                ns.doComplete();
            }
        }
    }

    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }

    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    public Throwable getThrowable() {
        return this.subscribers.get() == TERMINATED ? this.error : null;
    }

    int subscriberCount() {
        return this.subscribers.get().length;
    }

    static final class NonoSubscription
    extends BasicNonoIntQueueSubscription {
        private static final long serialVersionUID = 8377121611843740196L;
        final Subscriber<? super Void> downstream;
        final NonoProcessor parent;

        NonoSubscription(Subscriber<? super Void> downstream, NonoProcessor parent) {
            this.downstream = downstream;
            this.parent = parent;
        }

        public void cancel() {
            if (this.compareAndSet(0, 1)) {
                this.parent.delete(this);
            }
        }

        void doError(Throwable t) {
            if (this.compareAndSet(0, 1)) {
                this.downstream.onError(t);
            }
        }

        void doComplete() {
            if (this.compareAndSet(0, 1)) {
                this.downstream.onComplete();
            }
        }
    }
}

