/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.BasicNonoIntQueueSubscription;
import hu.akarnokd.rxjava3.basetypes.Nono;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoRetryWhile
extends Nono {
    final Nono source;
    final Predicate<? super Throwable> predicate;

    NonoRetryWhile(Nono source, Predicate<? super Throwable> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        this.source.subscribe(new RetryUntilSubscriber(s, this.predicate, this.source));
    }

    static final class RetryUntilSubscriber
    extends BasicNonoIntQueueSubscription
    implements Subscriber<Void> {
        private static final long serialVersionUID = -3208438978515192633L;
        protected final Subscriber<? super Void> downstream;
        final Nono source;
        final Predicate<? super Throwable> predicate;
        final AtomicReference<Subscription> upstream;
        volatile boolean active;
        boolean once;

        RetryUntilSubscriber(Subscriber<? super Void> downstream, Predicate<? super Throwable> predicate, Nono source) {
            this.downstream = downstream;
            this.predicate = predicate;
            this.source = source;
            this.upstream = new AtomicReference();
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.replace(this.upstream, (Subscription)s);
            if (!this.once) {
                this.once = true;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(Void t) {
        }

        public void onError(Throwable t) {
            boolean b;
            try {
                b = this.predicate.test((Object)t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.downstream.onError((Throwable)new CompositeException(new Throwable[]{t, ex}));
                return;
            }
            if (!b) {
                this.downstream.onError(t);
            } else {
                this.active = false;
                if (this.getAndIncrement() == 0) {
                    do {
                        if (SubscriptionHelper.CANCELLED == this.upstream.get()) {
                            return;
                        }
                        if (this.active) continue;
                        this.active = true;
                        this.source.subscribe(this);
                    } while (this.decrementAndGet() != 0);
                }
            }
        }

        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

