/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Perhaps;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsCache<T>
extends Perhaps<T>
implements Subscriber<T> {
    static final CacheSubscription[] EMPTY = new CacheSubscription[0];
    static final CacheSubscription[] TERMINATED = new CacheSubscription[0];
    final Perhaps<T> source;
    final AtomicBoolean once;
    final AtomicReference<CacheSubscription<T>[]> subscribers;
    T value;
    Throwable error;

    PerhapsCache(Perhaps<T> source) {
        this.source = source;
        this.once = new AtomicBoolean();
        this.subscribers = new AtomicReference<CacheSubscription[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        CacheSubscription<? super T> inner = new CacheSubscription<T>(s, this);
        s.onSubscribe(inner);
        if (this.add(inner)) {
            if (inner.isCancelled()) {
                this.remove(inner);
            }
            if (this.once.compareAndSet(false, true)) {
                this.source.subscribe(this);
            }
        } else if (!inner.isCancelled()) {
            Throwable ex = this.error;
            if (ex != null) {
                inner.error(ex);
            } else {
                T v = this.value;
                if (v != null) {
                    inner.complete(v);
                } else {
                    inner.complete();
                }
            }
        }
    }

    boolean add(CacheSubscription<T> inner) {
        CacheSubscription[] b;
        CacheSubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new CacheSubscription[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(CacheSubscription<T> inner) {
        CacheSubscription<T>[] a;
        int n;
        while ((n = (a = this.subscribers.get()).length) != 0) {
            CacheSubscription[] b;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) break;
            if (n == 1) {
                b = EMPTY;
            } else {
                b = new CacheSubscription[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            }
            if (!this.subscribers.compareAndSet(a, b)) continue;
            break;
        }
    }

    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    public void onNext(T t) {
        this.value = t;
    }

    public void onError(Throwable t) {
        this.error = t;
        for (CacheSubscription inner : this.subscribers.getAndSet(TERMINATED)) {
            inner.error(t);
        }
    }

    public void onComplete() {
        T t = this.value;
        CacheSubscription[] inners = this.subscribers.getAndSet(TERMINATED);
        if (t != null) {
            for (CacheSubscription inner : inners) {
                inner.complete(t);
            }
        } else {
            for (CacheSubscription inner : inners) {
                inner.complete();
            }
        }
    }

    static final class CacheSubscription<T>
    extends DeferredScalarSubscription<T> {
        private static final long serialVersionUID = -44000898247441619L;
        final AtomicReference<Object> parent;

        CacheSubscription(Subscriber<? super T> downstream, PerhapsCache<T> parent) {
            super(downstream);
            this.parent = new AtomicReference<PerhapsCache<T>>(parent);
        }

        public void cancel() {
            super.cancel();
            Object o = this.parent.get();
            if (o != null && this.parent.compareAndSet(o, null)) {
                ((PerhapsCache)o).remove(this);
            }
        }

        void error(Throwable ex) {
            this.downstream.onError(ex);
        }

        void complete() {
            this.downstream.onComplete();
        }
    }
}

