/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Perhaps;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsDelaySubscription<T>
extends Perhaps<T> {
    final Perhaps<T> source;
    final Publisher<?> other;

    PerhapsDelaySubscription(Perhaps<T> source, Publisher<?> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.other.subscribe(new DelaySubscriber<T>(s, this.source));
    }

    static final class DelaySubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<Object> {
        private static final long serialVersionUID = -9119999967998769573L;
        final Perhaps<T> source;
        final SourceSubscriber sourceSubscriber;
        Subscription upstream;

        DelaySubscriber(Subscriber<? super T> downstream, Perhaps<T> source) {
            super(downstream);
            this.source = source;
            this.sourceSubscriber = new SourceSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(Object t) {
            if (this.upstream != SubscriptionHelper.CANCELLED) {
                this.upstream.cancel();
                this.upstream = SubscriptionHelper.CANCELLED;
                this.source.subscribe(this.sourceSubscriber);
            }
        }

        public void onError(Throwable t) {
            if (this.upstream == SubscriptionHelper.CANCELLED) {
                RxJavaPlugins.onError((Throwable)t);
            } else {
                this.downstream.onError(t);
            }
        }

        public void onComplete() {
            if (this.upstream != SubscriptionHelper.CANCELLED) {
                this.upstream = SubscriptionHelper.CANCELLED;
                this.source.subscribe(this.sourceSubscriber);
            }
        }

        void otherSignal(T v) {
            this.value = v;
        }

        void otherError(Throwable t) {
            this.downstream.onError(t);
        }

        void otherComplete() {
            Object v = this.value;
            if (v != null) {
                this.complete(v);
            } else {
                this.downstream.onComplete();
            }
        }

        public void cancel() {
            super.cancel();
            this.upstream.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.sourceSubscriber);
        }

        final class SourceSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<T> {
            private static final long serialVersionUID = -6651374802328276829L;

            SourceSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(T t) {
                DelaySubscriber.this.otherSignal(t);
            }

            public void onError(Throwable t) {
                DelaySubscriber.this.otherError(t);
            }

            public void onComplete() {
                DelaySubscriber.this.otherComplete();
            }
        }
    }
}

