/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Perhaps;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsRetryWhile<T>
extends Perhaps<T> {
    final Perhaps<T> source;
    final Predicate<? super Throwable> predicate;

    PerhapsRetryWhile(Perhaps<T> source, Predicate<? super Throwable> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        RetrySubscriber<T> parent = new RetrySubscriber<T>(s, this.predicate, this.source);
        s.onSubscribe(parent);
        parent.subscribeNext();
    }

    static final class RetrySubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -1726278593241855499L;
        final AtomicInteger wip;
        final AtomicReference<Subscription> upstream;
        final Perhaps<T> source;
        final Predicate<? super Throwable> predicate;
        volatile boolean active;

        RetrySubscriber(Subscriber<? super T> downstream, Predicate<? super Throwable> predicate, Perhaps<T> source) {
            super(downstream);
            this.predicate = predicate;
            this.source = source;
            this.wip = new AtomicInteger();
            this.upstream = new AtomicReference();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.replace(this.upstream, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            boolean b;
            try {
                b = this.predicate.test((Object)t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.downstream.onError((Throwable)new CompositeException(new Throwable[]{t, ex}));
                return;
            }
            if (b) {
                this.active = false;
                this.subscribeNext();
            } else {
                this.downstream.onError(t);
            }
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (SubscriptionHelper.CANCELLED == this.upstream.get()) {
                        return;
                    }
                    if (this.active) continue;
                    this.active = true;
                    this.source.subscribe(this);
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        public void onComplete() {
            Object v = this.value;
            if (v != null) {
                this.value = null;
                this.complete(v);
            } else {
                this.downstream.onComplete();
            }
        }

        public void cancel() {
            super.cancel();
            SubscriptionHelper.cancel(this.upstream);
        }
    }
}

