/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Perhaps;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsTakeUntil<T>
extends Perhaps<T> {
    final Perhaps<T> source;
    final Publisher<?> other;

    PerhapsTakeUntil(Perhaps<T> source, Publisher<?> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        TakeUntilSubscriber<? super T> parent = new TakeUntilSubscriber<T>(s);
        s.onSubscribe(parent);
        this.other.subscribe((Subscriber)parent.other);
        this.source.subscribe(parent);
    }

    static final class TakeUntilSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = 8414575379623209938L;
        final AtomicBoolean once;
        final AtomicReference<Subscription> upstream;
        final OtherSubscriber other = new OtherSubscriber();

        TakeUntilSubscriber(Subscriber<? super T> downstream) {
            super(downstream);
            this.upstream = new AtomicReference();
            this.once = new AtomicBoolean();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.upstream, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.once.compareAndSet(false, true)) {
                SubscriptionHelper.cancel((AtomicReference)this.other);
                this.complete(t);
            }
        }

        public void onError(Throwable t) {
            if (this.once.compareAndSet(false, true)) {
                SubscriptionHelper.cancel((AtomicReference)this.other);
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            if (!this.once.get() && this.once.compareAndSet(false, true)) {
                SubscriptionHelper.cancel((AtomicReference)this.other);
                this.downstream.onComplete();
            }
        }

        void otherSignal() {
            if (this.once.compareAndSet(false, true)) {
                SubscriptionHelper.cancel(this.upstream);
                this.downstream.onComplete();
            }
        }

        void otherError(Throwable e) {
            if (this.once.compareAndSet(false, true)) {
                SubscriptionHelper.cancel(this.upstream);
                this.downstream.onError(e);
            } else {
                RxJavaPlugins.onError((Throwable)e);
            }
        }

        public void cancel() {
            super.cancel();
            SubscriptionHelper.cancel(this.upstream);
            SubscriptionHelper.cancel((AtomicReference)this.other);
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Object> {
            private static final long serialVersionUID = 8999579172944042558L;

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
                ((Subscription)this.get()).cancel();
                TakeUntilSubscriber.this.otherSignal();
            }

            public void onError(Throwable t) {
                TakeUntilSubscriber.this.otherError(t);
            }

            public void onComplete() {
                TakeUntilSubscriber.this.otherSignal();
            }
        }
    }
}

