/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Solo;
import io.reactivex.rxjava3.core.SingleEmitter;
import io.reactivex.rxjava3.core.SingleOnSubscribe;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Cancellable;
import io.reactivex.rxjava3.internal.disposables.CancellableDisposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;

final class SoloCreate<T>
extends Solo<T> {
    final SingleOnSubscribe<T> onCreate;

    SoloCreate(SingleOnSubscribe<T> onCreate) {
        this.onCreate = onCreate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        SoloEmitter<T> parent = new SoloEmitter<T>(s);
        s.onSubscribe(parent);
        try {
            this.onCreate.subscribe(parent);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            parent.onError(ex);
        }
    }

    static final class SoloEmitter<T>
    extends DeferredScalarSubscription<T>
    implements SingleEmitter<T> {
        private static final long serialVersionUID = -7149477775653368644L;
        final AtomicReference<Disposable> resource = new AtomicReference();

        SoloEmitter(Subscriber<? super T> downstream) {
            super(downstream);
        }

        public void onSuccess(T t) {
            Disposable d = this.resource.getAndSet((Disposable)DisposableHelper.DISPOSED);
            if (d != DisposableHelper.DISPOSED) {
                this.complete(t);
                if (d != null) {
                    d.dispose();
                }
            }
        }

        public void onError(Throwable t) {
            if (!this.tryOnError(t)) {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public boolean tryOnError(Throwable t) {
            Disposable d = this.resource.getAndSet((Disposable)DisposableHelper.DISPOSED);
            if (d != DisposableHelper.DISPOSED) {
                this.downstream.onError(t);
                if (d != null) {
                    d.dispose();
                }
                return true;
            }
            return false;
        }

        public void setDisposable(Disposable d) {
            DisposableHelper.set(this.resource, (Disposable)d);
        }

        public void setCancellable(Cancellable c) {
            this.setDisposable((Disposable)new CancellableDisposable(c));
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.resource.get());
        }
    }
}

