/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Solo;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.fuseable.QueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloDelay<T>
extends Solo<T> {
    final Solo<T> source;
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;

    SoloDelay(Solo<T> source, long delay, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DelaySubscriber<T>(s, this.delay, this.unit, this.scheduler));
    }

    static final class DelaySubscriber<T>
    extends AtomicReference<Disposable>
    implements QueueSubscription<T>,
    Subscriber<T>,
    Runnable {
        private static final long serialVersionUID = 511073038536312798L;
        final Subscriber<? super T> downstream;
        final long delay;
        final TimeUnit unit;
        final Scheduler scheduler;
        Subscription upstream;
        T value;
        Throwable error;
        volatile boolean available;
        boolean outputFused;

        DelaySubscriber(Subscriber<? super T> downstream, long delay, TimeUnit unit, Scheduler scheduler) {
            this.downstream = downstream;
            this.delay = delay;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        public T poll() throws Exception {
            if (this.available) {
                T v = this.value;
                this.value = null;
                return v;
            }
            return null;
        }

        public boolean isEmpty() {
            return !this.available || this.value == null;
        }

        public void clear() {
            this.value = null;
        }

        public void request(long n) {
            this.upstream.request(n);
        }

        public void cancel() {
            this.upstream.cancel();
            DisposableHelper.dispose((AtomicReference)this);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            this.error = t;
            DisposableHelper.replace((AtomicReference)this, (Disposable)this.scheduler.scheduleDirect((Runnable)this, this.delay, this.unit));
        }

        public void onComplete() {
            DisposableHelper.replace((AtomicReference)this, (Disposable)this.scheduler.scheduleDirect((Runnable)this, this.delay, this.unit));
        }

        @Override
        public void run() {
            Throwable ex = this.error;
            if (ex != null) {
                this.downstream.onError(ex);
            } else {
                if (this.outputFused) {
                    this.available = true;
                    this.downstream.onNext(null);
                } else {
                    T v = this.value;
                    this.value = null;
                    this.downstream.onNext(v);
                }
                this.downstream.onComplete();
            }
        }

        public boolean offer(T value) {
            throw new UnsupportedOperationException();
        }

        public boolean offer(T v1, T v2) {
            throw new UnsupportedOperationException();
        }
    }
}

