/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Solo;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.internal.fuseable.QueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloDoFinally<T>
extends Solo<T> {
    final Solo<T> source;
    final Action onFinally;

    SoloDoFinally(Solo<T> source, Action onFinally) {
        this.source = source;
        this.onFinally = onFinally;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DoFinallySubscriber<T>(s, this.onFinally));
    }

    static final class DoFinallySubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -2447716698732984984L;
        final Subscriber<? super T> downstream;
        final Action onFinally;
        Subscription upstream;
        QueueSubscription<T> queue;
        int sourceMode;

        DoFinallySubscriber(Subscriber<? super T> downstream, Action onFinally) {
            this.downstream = downstream;
            this.onFinally = onFinally;
        }

        public void cancel() {
            this.upstream.cancel();
            this.runFinally();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                if (s instanceof QueueSubscription) {
                    this.queue = (QueueSubscription)s;
                }
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
            this.runFinally();
        }

        public void onComplete() {
            this.downstream.onComplete();
            this.runFinally();
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    RxJavaPlugins.onError((Throwable)ex);
                }
            }
        }

        public int requestFusion(int mode) {
            QueueSubscription<T> qs = this.queue;
            if (qs != null && (mode & 4) == 0) {
                int m;
                this.sourceMode = m = qs.requestFusion(mode);
                return m;
            }
            return 0;
        }

        public T poll() throws Throwable {
            Object v = this.queue.poll();
            if (this.sourceMode == 1 && v == null) {
                this.runFinally();
            }
            return (T)v;
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void clear() {
            this.queue.clear();
        }

        public void request(long n) {
            this.upstream.request(n);
        }
    }
}

