/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Solo;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloFlatMap<T, R>
extends Solo<R> {
    final Solo<T> source;
    final Function<? super T, ? extends Solo<? extends R>> mapper;

    SoloFlatMap(Solo<T> source, Function<? super T, ? extends Solo<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new FlatMapSubscriber<T, R>(s, this.mapper));
    }

    static final class FlatMapSubscriber<T, R>
    extends DeferredScalarSubscription<R>
    implements Subscriber<T> {
        private static final long serialVersionUID = -7631998337002592538L;
        final Function<? super T, ? extends Solo<? extends R>> mapper;
        final NextSubscriber nextSubscriber;
        Subscription upstream;

        FlatMapSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends Solo<? extends R>> mapper) {
            super(downstream);
            this.mapper = mapper;
            this.nextSubscriber = new NextSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Solo sp;
            try {
                sp = (Solo)Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Solo");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.downstream.onError(ex);
                return;
            }
            sp.subscribe(this.nextSubscriber);
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void onComplete() {
        }

        public void cancel() {
            super.cancel();
            this.upstream.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.nextSubscriber);
        }

        void nextComplete() {
            this.complete(this.value);
        }

        final class NextSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<R> {
            private static final long serialVersionUID = 5161815655607865861L;

            NextSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(R t) {
                FlatMapSubscriber.this.value = t;
            }

            public void onError(Throwable t) {
                FlatMapSubscriber.this.downstream.onError(t);
            }

            public void onComplete() {
                FlatMapSubscriber.this.nextComplete();
            }
        }
    }
}

