/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Solo;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import java.util.Objects;
import org.reactivestreams.Subscriber;

final class SoloMap<T, R>
extends Solo<R> {
    final Solo<T> source;
    final Function<? super T, ? extends R> mapper;

    SoloMap(Solo<T> source, Function<? super T, ? extends R> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe((Subscriber<T>)new MapSubscriber<T, R>(s, this.mapper));
    }

    static final class MapSubscriber<T, R>
    extends BasicFuseableSubscriber<T, R> {
        final Function<? super T, ? extends R> mapper;

        MapSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends R> mapper) {
            super(downstream);
            this.mapper = mapper;
        }

        public void onNext(T t) {
            if (!this.done) {
                if (this.sourceMode == 0) {
                    Object v;
                    try {
                        v = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null value");
                    }
                    catch (Throwable ex) {
                        this.fail(ex);
                        return;
                    }
                    this.downstream.onNext(v);
                } else {
                    this.downstream.onNext(null);
                }
            }
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        public R poll() throws Throwable {
            Object v = this.qs.poll();
            if (v != null) {
                return (R)Objects.requireNonNull(this.mapper.apply(v), "The mapper returned a null value");
            }
            return null;
        }
    }
}

