/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Solo;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.fuseable.QueueSubscription;
import io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import java.util.Objects;
import org.reactivestreams.Subscriber;

final class SoloMapError<T>
extends Solo<T> {
    final Solo<T> source;
    final Function<? super Throwable, ? extends Throwable> errorMapper;

    SoloMapError(Solo<T> source, Function<? super Throwable, ? extends Throwable> errorMapper) {
        this.source = source;
        this.errorMapper = errorMapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe((Subscriber<? super T>)new MapErrorSubscriber<T>(s, this.errorMapper));
    }

    static final class MapErrorSubscriber<T>
    extends BasicFuseableSubscriber<T, T> {
        final Function<? super Throwable, ? extends Throwable> errorMapper;

        MapErrorSubscriber(Subscriber<? super T> downstream, Function<? super Throwable, ? extends Throwable> errorMapper) {
            super(downstream);
            this.errorMapper = errorMapper;
        }

        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        public void onError(Throwable t) {
            Throwable ex;
            try {
                ex = (Throwable)Objects.requireNonNull(this.errorMapper.apply((Object)t), "The errorMapper returned a null Throwable");
            }
            catch (Throwable exc) {
                Exceptions.throwIfFatal((Throwable)exc);
                ex = new CompositeException(new Throwable[]{t, exc});
            }
            super.onError(ex);
        }

        public int requestFusion(int mode) {
            QueueSubscription qs = this.qs;
            return qs != null ? qs.requestFusion(mode) : 0;
        }

        public T poll() throws Throwable {
            return (T)this.qs.poll();
        }
    }
}

