/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Solo;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloOnErrorResumeNext<T>
extends Solo<T> {
    final Solo<T> source;
    final Function<? super Throwable, ? extends Solo<T>> errorHandler;

    SoloOnErrorResumeNext(Solo<T> source, Function<? super Throwable, ? extends Solo<T>> errorHandler) {
        this.source = source;
        this.errorHandler = errorHandler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new OnErrorReturnItemSubscriber<T>(s, this.errorHandler));
    }

    static final class OnErrorReturnItemSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -7631998337002592538L;
        final Function<? super Throwable, ? extends Solo<T>> errorHandler;
        final NextSubscriber nextSubscriber;
        Subscription upstream;

        OnErrorReturnItemSubscriber(Subscriber<? super T> downstream, Function<? super Throwable, ? extends Solo<T>> errorHandler) {
            super(downstream);
            this.errorHandler = errorHandler;
            this.nextSubscriber = new NextSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            Solo sp;
            try {
                sp = (Solo)Objects.requireNonNull(this.errorHandler.apply((Object)t), "The errorHandler returned a null Solo");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.downstream.onError((Throwable)new CompositeException(new Throwable[]{t, ex}));
                return;
            }
            sp.subscribe(this.nextSubscriber);
        }

        public void onComplete() {
            Object v = this.value;
            if (v != null) {
                this.complete(v);
            } else {
                this.downstream.onComplete();
            }
        }

        public void cancel() {
            super.cancel();
            this.upstream.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.nextSubscriber);
        }

        final class NextSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<T> {
            private static final long serialVersionUID = 5161815655607865861L;

            NextSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(T t) {
                OnErrorReturnItemSubscriber.this.onNext(t);
            }

            public void onError(Throwable t) {
                OnErrorReturnItemSubscriber.this.downstream.onError(t);
            }

            public void onComplete() {
                OnErrorReturnItemSubscriber.this.onComplete();
            }
        }
    }
}

