/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Solo;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloOnErrorResumeWith<T>
extends Solo<T> {
    final Solo<T> source;
    final Solo<T> next;

    SoloOnErrorResumeWith(Solo<T> source, Solo<T> next) {
        this.source = source;
        this.next = next;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new OnErrorResumeWithSubscriber<T>(s, this.next));
    }

    static final class OnErrorResumeWithSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -7631998337002592538L;
        final Solo<T> next;
        final NextSubscriber nextSubscriber;
        Subscription upstream;

        OnErrorResumeWithSubscriber(Subscriber<? super T> downstream, Solo<T> next) {
            super(downstream);
            this.next = next;
            this.nextSubscriber = new NextSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            this.next.subscribe(this.nextSubscriber);
        }

        public void onComplete() {
            Object v = this.value;
            if (v != null) {
                this.complete(v);
            } else {
                this.downstream.onComplete();
            }
        }

        public void cancel() {
            super.cancel();
            this.upstream.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.nextSubscriber);
        }

        final class NextSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<T> {
            private static final long serialVersionUID = 5161815655607865861L;

            NextSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(T t) {
                OnErrorResumeWithSubscriber.this.onNext(t);
            }

            public void onError(Throwable t) {
                OnErrorResumeWithSubscriber.this.downstream.onError(t);
            }

            public void onComplete() {
                OnErrorResumeWithSubscriber.this.onComplete();
            }
        }
    }
}

