/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Solo;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloTakeUntil<T>
extends Solo<T> {
    final Solo<T> source;
    final Publisher<?> other;

    SoloTakeUntil(Solo<T> source, Publisher<?> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        TakeUntilSubscriber<? super T> parent = new TakeUntilSubscriber<T>(s);
        s.onSubscribe(parent);
        this.other.subscribe((Subscriber)parent.other);
        this.source.subscribe(parent);
    }

    static final class TakeUntilSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -3094876274753374720L;
        final AtomicReference<Subscription> upstream = new AtomicReference();
        final OtherSubscriber other = new OtherSubscriber();
        final AtomicBoolean once = new AtomicBoolean();

        TakeUntilSubscriber(Subscriber<? super T> downstream) {
            super(downstream);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.upstream, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            SubscriptionHelper.cancel((AtomicReference)this.other);
            if (this.once.compareAndSet(false, true)) {
                this.value = null;
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            SubscriptionHelper.cancel((AtomicReference)this.other);
            if (this.once.compareAndSet(false, true)) {
                Object v = this.value;
                if (v != null) {
                    this.value = null;
                    this.complete(v);
                } else {
                    this.downstream.onComplete();
                }
            }
        }

        void otherError(Throwable t) {
            SubscriptionHelper.cancel(this.upstream);
            if (this.once.compareAndSet(false, true)) {
                this.value = null;
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Object> {
            private static final long serialVersionUID = -7055801798042780544L;
            boolean done;

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
                if (!this.done) {
                    ((Subscription)this.get()).cancel();
                    this.onComplete();
                }
            }

            public void onError(Throwable t) {
                if (this.done) {
                    RxJavaPlugins.onError((Throwable)t);
                } else {
                    this.done = true;
                    TakeUntilSubscriber.this.otherError(t);
                }
            }

            public void onComplete() {
                if (!this.done) {
                    this.done = true;
                    TakeUntilSubscriber.this.otherError(new NoSuchElementException());
                }
            }
        }
    }
}

