/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Solo;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloTimeout<T>
extends Solo<T> {
    final Solo<T> source;
    final Publisher<?> other;
    final Solo<T> fallback;

    SoloTimeout(Solo<T> source, Publisher<?> other, Solo<T> fallback) {
        this.source = source;
        this.other = other;
        this.fallback = fallback;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        TimeoutSubscriber<? super T> parent = new TimeoutSubscriber<T>(s, this.fallback);
        s.onSubscribe(parent);
        this.other.subscribe((Subscriber)parent.other);
        this.source.subscribe(parent);
    }

    static final class TimeoutSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -2613153829201889588L;
        final AtomicReference<Subscription> upstream = new AtomicReference();
        final Solo<T> fallback;
        final OtherSubscriber other;
        final FallbackSubscriber fallbackSubscriber;
        final AtomicBoolean once;

        TimeoutSubscriber(Subscriber<? super T> downstream, Solo<T> fallback) {
            super(downstream);
            this.fallback = fallback;
            this.once = new AtomicBoolean();
            this.other = new OtherSubscriber();
            this.fallbackSubscriber = fallback != null ? new FallbackSubscriber() : null;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.upstream, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            SubscriptionHelper.cancel((AtomicReference)this.other);
            if (this.once.compareAndSet(false, true)) {
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            SubscriptionHelper.cancel((AtomicReference)this.other);
            if (this.once.compareAndSet(false, true)) {
                this.complete(this.value);
            }
        }

        void otherComplete() {
            SubscriptionHelper.cancel(this.upstream);
            if (this.once.compareAndSet(false, true)) {
                Solo<T> f = this.fallback;
                if (f != null) {
                    f.subscribe(this.fallbackSubscriber);
                } else {
                    this.downstream.onError((Throwable)new TimeoutException());
                }
            }
        }

        void otherError(Throwable ex) {
            SubscriptionHelper.cancel(this.upstream);
            if (this.once.compareAndSet(false, true)) {
                this.downstream.onError(ex);
            } else {
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        public void cancel() {
            super.cancel();
            SubscriptionHelper.cancel(this.upstream);
            SubscriptionHelper.cancel((AtomicReference)this.other);
            FallbackSubscriber fs = this.fallbackSubscriber;
            if (fs != null) {
                SubscriptionHelper.cancel((AtomicReference)fs);
            }
        }

        void fallbackComplete(T v) {
            this.complete(v);
        }

        void fallbackError(Throwable ex) {
            this.downstream.onError(ex);
        }

        final class FallbackSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<T> {
            private static final long serialVersionUID = -1360947483517311225L;
            T v;

            FallbackSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(T t) {
                this.v = t;
            }

            public void onError(Throwable t) {
                TimeoutSubscriber.this.fallbackError(t);
            }

            public void onComplete() {
                Object val = this.v;
                this.v = null;
                TimeoutSubscriber.this.fallbackComplete(val);
            }
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Object> {
            private static final long serialVersionUID = -8725214806550415150L;
            boolean once;

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
                if (!this.once) {
                    this.once = true;
                    ((Subscription)this.get()).cancel();
                    TimeoutSubscriber.this.otherComplete();
                }
            }

            public void onError(Throwable t) {
                if (!this.once) {
                    this.once = true;
                    TimeoutSubscriber.this.otherError(t);
                } else {
                    RxJavaPlugins.onError((Throwable)t);
                }
            }

            public void onComplete() {
                if (!this.once) {
                    this.once = true;
                    TimeoutSubscriber.this.otherComplete();
                }
            }
        }
    }
}

