/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.basetypes;

import hu.akarnokd.rxjava3.basetypes.Solo;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloUsing<T, R>
extends Solo<T> {
    final Supplier<R> resourceSupplier;
    final Function<? super R, ? extends Solo<T>> sourceSupplier;
    final Consumer<? super R> disposer;
    final boolean eager;

    SoloUsing(Supplier<R> resourceSupplier, Function<? super R, ? extends Solo<T>> sourceSupplier, Consumer<? super R> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        Solo np;
        Object resource;
        try {
            resource = this.resourceSupplier.get();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        try {
            np = (Solo)Objects.requireNonNull(this.sourceSupplier.apply(resource), "The sourceSupplier returned a null Nono");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal((Throwable)ex2);
            if (this.eager) {
                CompositeException ex2;
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal((Throwable)exc);
                    ex2 = new CompositeException(new Throwable[]{ex2, exc});
                }
                EmptySubscription.error((Throwable)ex2, s);
            } else {
                EmptySubscription.error((Throwable)ex2, s);
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal((Throwable)exc);
                    RxJavaPlugins.onError((Throwable)exc);
                }
            }
            return;
        }
        np.subscribe(new UsingSubscriber<T, R>(s, resource, this.disposer, this.eager));
    }

    static final class UsingSubscriber<T, R>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = 5500674592438910341L;
        final Consumer<? super R> disposer;
        final boolean eager;
        final AtomicBoolean once;
        Subscription upstream;
        R resource;

        UsingSubscriber(Subscriber<? super T> downstream, R resource, Consumer<? super R> disposer, boolean eager) {
            super(downstream);
            this.resource = resource;
            this.disposer = disposer;
            this.eager = eager;
            this.once = new AtomicBoolean();
        }

        public void cancel() {
            if (this.once.compareAndSet(false, true)) {
                this.disposeFinally();
            }
        }

        void disposeFinally() {
            try {
                this.disposer.accept(this.resource);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            if (this.eager && this.once.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    t = new CompositeException(new Throwable[]{t, ex});
                }
            }
            this.downstream.onError(t);
            if (!this.eager && this.once.compareAndSet(false, true)) {
                this.disposeFinally();
            }
        }

        public void onComplete() {
            Object v;
            if (this.eager && this.once.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.downstream.onError(ex);
                    return;
                }
            }
            if ((v = this.value) == null) {
                this.downstream.onComplete();
            } else {
                this.complete(v);
            }
            if (!this.eager && this.once.compareAndSet(false, true)) {
                this.disposeFinally();
            }
        }
    }
}

