/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.consumers;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.OnErrorNotImplementedException;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.observers.LambdaConsumerIntrospection;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

final class DisposableAutoReleaseSubscriber<T>
extends AtomicReference<Subscription>
implements FlowableSubscriber<T>,
Disposable,
LambdaConsumerIntrospection {
    private static final long serialVersionUID = 8924480688481408726L;
    final AtomicReference<CompositeDisposable> composite;
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;

    DisposableAutoReleaseSubscriber(CompositeDisposable composite, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.composite = new AtomicReference<CompositeDisposable>(composite);
    }

    public void onNext(T t) {
        if (this.get() != SubscriptionHelper.CANCELLED) {
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                ((Subscription)this.get()).cancel();
                this.onError(e);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.get() != SubscriptionHelper.CANCELLED) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            if (this.onError != null) {
                try {
                    this.onError.accept((Object)t);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
                }
            } else {
                RxJavaPlugins.onError((Throwable)new OnErrorNotImplementedException(t));
            }
        } else {
            RxJavaPlugins.onError((Throwable)t);
        }
        this.removeSelf();
    }

    public void onComplete() {
        if (this.get() != SubscriptionHelper.CANCELLED) {
            this.lazySet(SubscriptionHelper.CANCELLED);
            try {
                this.onComplete.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                RxJavaPlugins.onError((Throwable)e);
            }
        }
        this.removeSelf();
    }

    public void dispose() {
        SubscriptionHelper.cancel((AtomicReference)this);
        this.removeSelf();
    }

    void removeSelf() {
        CompositeDisposable c = this.composite.getAndSet(null);
        if (c != null) {
            c.delete((Disposable)this);
        }
    }

    public boolean isDisposed() {
        return SubscriptionHelper.CANCELLED == this.get();
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
            s.request(Long.MAX_VALUE);
        }
    }

    public boolean hasCustomOnError() {
        return this.onError != null;
    }
}

