/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.debug;

import java.util.HashSet;

public final class RxJavaAssemblyException
extends RuntimeException {
    private static final long serialVersionUID = -6757520270386306081L;
    final String stacktrace = RxJavaAssemblyException.buildStackTrace();

    public static String buildStackTrace() {
        StringBuilder b = new StringBuilder();
        StackTraceElement[] es = Thread.currentThread().getStackTrace();
        b.append("RxJavaAssemblyException: assembled");
        for (StackTraceElement e : es) {
            if (!RxJavaAssemblyException.filter(e)) continue;
            b.append(System.lineSeparator()).append("\tat ").append(e);
        }
        return b.toString();
    }

    private static boolean filter(StackTraceElement e) {
        if (e.getLineNumber() == 1) {
            return false;
        }
        String cn = e.getClassName();
        if (cn.contains("java.lang.Thread")) {
            return false;
        }
        if (cn.contains("junit.runner") || cn.contains("org.junit.internal") || cn.contains("junit4.runner")) {
            return false;
        }
        if (cn.contains("java.lang.reflect") || cn.contains("sun.reflect")) {
            return false;
        }
        if (cn.contains(".RxJavaAssemblyException")) {
            return false;
        }
        return !cn.contains("OnAssembly") && !cn.contains("RxJavaAssemblyTracking") && !cn.contains("RxJavaPlugins");
    }

    public String stacktrace() {
        return this.stacktrace;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        this.setStackTrace(new StackTraceElement[0]);
        return this;
    }

    public Throwable appendLast(Throwable ex) {
        Throwable r = ex;
        HashSet<Throwable> memory = new HashSet<Throwable>();
        while (ex.getCause() != null) {
            if (memory.add(ex)) {
                ex = ex.getCause();
                continue;
            }
            return r;
        }
        try {
            ex.initCause(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return r;
    }

    public static RxJavaAssemblyException find(Throwable ex) {
        HashSet<Throwable> memory = new HashSet<Throwable>();
        while (ex != null) {
            if (ex instanceof RxJavaAssemblyException) {
                return (RxJavaAssemblyException)ex;
            }
            if (memory.add(ex)) {
                ex = ex.getCause();
                continue;
            }
            return null;
        }
        return null;
    }

    @Override
    public String getMessage() {
        return this.stacktrace;
    }
}

