/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.debug.multihook;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.BiConsumer;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public class MultiHandlerManager<H> {
    protected final CopyOnWriteArrayList<HandlerRegistration<H>> handlers = new CopyOnWriteArrayList();

    @NonNull
    public final Disposable register(@NonNull H handler) {
        Objects.requireNonNull(handler, "handler is null");
        HandlerRegistration<H> hr = new HandlerRegistration<H>(this, handler);
        this.handlers.add(hr);
        return hr;
    }

    final void unregister(HandlerRegistration<H> handler) {
        this.handlers.remove(handler);
    }

    public final void forEach(@NonNull Consumer<H> consumer) {
        Objects.requireNonNull(consumer, "consumer is null");
        Iterator<HandlerRegistration<H>> it = this.handlers.iterator();
        while (it.hasNext()) {
            try {
                HandlerRegistration<H> hr = it.next();
                Object h = hr.get();
                if (h == null) continue;
                consumer.accept(h);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, ex);
            }
        }
    }

    public final <S> void forEach(S state, @NonNull BiConsumer<S, H> consumer) {
        Objects.requireNonNull(consumer, "consumer is null");
        Iterator<HandlerRegistration<H>> it = this.handlers.iterator();
        while (it.hasNext()) {
            try {
                HandlerRegistration<H> hr = it.next();
                Object h = hr.get();
                if (h == null) continue;
                consumer.accept(state, h);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, ex);
            }
        }
    }

    public final void clear() {
        this.handlers.clear();
    }

    public final boolean hasHandlers() {
        return !this.handlers.isEmpty();
    }

    static final class HandlerRegistration<H>
    extends AtomicReference<H>
    implements Disposable {
        private static final long serialVersionUID = -3761960052630027297L;
        final MultiHandlerManager<H> parent;

        HandlerRegistration(MultiHandlerManager<H> parent, H handler) {
            this.parent = parent;
            this.lazySet(handler);
        }

        public void dispose() {
            Object h = this.getAndSet(null);
            if (h != null) {
                this.parent.unregister(this);
            }
        }

        public boolean isDisposed() {
            return this.get() == null;
        }
    }
}

