/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.debug.validator;

import hu.akarnokd.rxjava3.debug.validator.MultipleOnSubscribeCallsException;
import hu.akarnokd.rxjava3.debug.validator.MultipleTerminationsException;
import hu.akarnokd.rxjava3.debug.validator.NullOnErrorParameterException;
import hu.akarnokd.rxjava3.debug.validator.NullOnSubscribeParameterException;
import hu.akarnokd.rxjava3.debug.validator.OnSubscribeNotCalledException;
import hu.akarnokd.rxjava3.debug.validator.ProtocolNonConformanceException;
import hu.akarnokd.rxjava3.functions.PlainConsumer;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.Disposable;

final class CompletableValidator
extends Completable {
    final Completable source;
    final PlainConsumer<ProtocolNonConformanceException> onViolation;

    CompletableValidator(Completable source, PlainConsumer<ProtocolNonConformanceException> onViolation) {
        this.source = source;
        this.onViolation = onViolation;
    }

    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe((CompletableObserver)new ValidatorConsumer(observer, this.onViolation));
    }

    static final class ValidatorConsumer
    implements CompletableObserver,
    Disposable {
        final CompletableObserver downstream;
        final PlainConsumer<ProtocolNonConformanceException> onViolation;
        Disposable upstream;
        boolean done;

        ValidatorConsumer(CompletableObserver downstream, PlainConsumer<ProtocolNonConformanceException> onViolation) {
            this.downstream = downstream;
            this.onViolation = onViolation;
        }

        public void onSubscribe(Disposable d) {
            Disposable u;
            if (d == null) {
                this.onViolation.accept(new NullOnSubscribeParameterException());
            }
            if ((u = this.upstream) != null) {
                this.onViolation.accept(new MultipleOnSubscribeCallsException());
            }
            this.upstream = d;
            this.downstream.onSubscribe((Disposable)this);
        }

        public void onError(Throwable e) {
            if (e == null) {
                this.onViolation.accept(new NullOnErrorParameterException());
            }
            if (this.upstream == null) {
                this.onViolation.accept(new OnSubscribeNotCalledException(e));
            }
            if (this.done) {
                this.onViolation.accept(new MultipleTerminationsException(e));
            } else {
                this.done = true;
                this.downstream.onError(e);
            }
        }

        public void onComplete() {
            if (this.upstream == null) {
                OnSubscribeNotCalledException ex = new OnSubscribeNotCalledException();
                this.onViolation.accept(ex);
            }
            if (this.done) {
                this.onViolation.accept(new MultipleTerminationsException());
            } else {
                this.done = true;
                this.downstream.onComplete();
            }
        }

        public void dispose() {
            this.upstream.dispose();
        }

        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

