/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.debug.validator;

import hu.akarnokd.rxjava3.debug.validator.MultipleOnSubscribeCallsException;
import hu.akarnokd.rxjava3.debug.validator.MultipleTerminationsException;
import hu.akarnokd.rxjava3.debug.validator.NullOnErrorParameterException;
import hu.akarnokd.rxjava3.debug.validator.NullOnSubscribeParameterException;
import hu.akarnokd.rxjava3.debug.validator.NullOnSuccessParameterException;
import hu.akarnokd.rxjava3.debug.validator.OnSubscribeNotCalledException;
import hu.akarnokd.rxjava3.debug.validator.OnSuccessAfterTerminationException;
import hu.akarnokd.rxjava3.debug.validator.ProtocolNonConformanceException;
import hu.akarnokd.rxjava3.functions.PlainConsumer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;

final class SingleValidator<T>
extends Single<T> {
    final Single<T> source;
    final PlainConsumer<ProtocolNonConformanceException> onViolation;

    SingleValidator(Single<T> source, PlainConsumer<ProtocolNonConformanceException> onViolation) {
        this.source = source;
        this.onViolation = onViolation;
    }

    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new ValidatorConsumer<T>(observer, this.onViolation));
    }

    static final class ValidatorConsumer<T>
    implements SingleObserver<T>,
    Disposable {
        final SingleObserver<? super T> downstream;
        final PlainConsumer<ProtocolNonConformanceException> onViolation;
        Disposable upstream;
        boolean done;

        ValidatorConsumer(SingleObserver<? super T> downstream, PlainConsumer<ProtocolNonConformanceException> onViolation) {
            this.downstream = downstream;
            this.onViolation = onViolation;
        }

        public void onSubscribe(Disposable d) {
            Disposable u;
            if (d == null) {
                this.onViolation.accept(new NullOnSubscribeParameterException());
            }
            if ((u = this.upstream) != null) {
                this.onViolation.accept(new MultipleOnSubscribeCallsException());
            }
            this.upstream = d;
            this.downstream.onSubscribe((Disposable)this);
        }

        public void onSuccess(T t) {
            if (t == null) {
                this.onViolation.accept(new NullOnSuccessParameterException());
            }
            if (this.upstream == null) {
                this.onViolation.accept(new OnSubscribeNotCalledException());
            }
            if (this.done) {
                this.onViolation.accept(new OnSuccessAfterTerminationException());
            } else {
                this.done = true;
                this.downstream.onSuccess(t);
            }
        }

        public void onError(Throwable e) {
            if (e == null) {
                this.onViolation.accept(new NullOnErrorParameterException());
            }
            if (this.upstream == null) {
                this.onViolation.accept(new OnSubscribeNotCalledException(e));
            }
            if (this.done) {
                this.onViolation.accept(new MultipleTerminationsException(e));
            } else {
                this.done = true;
                this.downstream.onError(e);
            }
        }

        public void dispose() {
            this.upstream.dispose();
        }

        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

