/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.expr;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BooleanSupplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableWhileDoWhile<T>
extends Observable<T> {
    final ObservableSource<? extends T> source;
    final BooleanSupplier preCondition;
    final BooleanSupplier postCondition;

    ObservableWhileDoWhile(ObservableSource<? extends T> source, BooleanSupplier preCondition, BooleanSupplier postCondition) {
        this.source = source;
        this.preCondition = preCondition;
        this.postCondition = postCondition;
    }

    protected void subscribeActual(Observer<? super T> observer) {
        boolean b;
        try {
            b = this.preCondition.getAsBoolean();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptyDisposable.error((Throwable)ex, observer);
            return;
        }
        if (b) {
            WhileDoWhileObserver<T> parent = new WhileDoWhileObserver<T>(observer, this.postCondition, this.source);
            observer.onSubscribe(parent);
            parent.subscribeNext();
        } else {
            EmptyDisposable.complete(observer);
        }
    }

    static final class WhileDoWhileObserver<T>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -5255585317630843019L;
        final Observer<? super T> downstream;
        final AtomicInteger wip;
        final BooleanSupplier postCondition;
        final ObservableSource<? extends T> source;
        volatile boolean active;

        WhileDoWhileObserver(Observer<? super T> downstream, BooleanSupplier postCondition, ObservableSource<? extends T> source) {
            this.downstream = downstream;
            this.wip = new AtomicInteger();
            this.postCondition = postCondition;
            this.source = source;
        }

        public void onSubscribe(Disposable d) {
            DisposableHelper.replace((AtomicReference)this, (Disposable)d);
        }

        public void onNext(T value) {
            this.downstream.onNext(value);
        }

        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        public void onComplete() {
            boolean b;
            try {
                b = this.postCondition.getAsBoolean();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.downstream.onError(ex);
                return;
            }
            if (b) {
                this.active = false;
                this.subscribeNext();
            } else {
                this.downstream.onComplete();
            }
        }

        public void dispose() {
            DisposableHelper.dispose((AtomicReference)this);
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            do {
                if (this.isDisposed()) {
                    return;
                }
                if (this.active) continue;
                this.active = true;
                this.source.subscribe((Observer)this);
            } while (this.wip.decrementAndGet() != 0);
        }
    }
}

