/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.joins;

import hu.akarnokd.rxjava3.joins.ActivePlan0;
import hu.akarnokd.rxjava3.joins.JoinObserver;
import io.reactivex.rxjava3.core.Notification;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

final class JoinObserver1<T>
implements Observer<Notification<T>>,
JoinObserver {
    private Object gate;
    private final Observable<T> source;
    private final Consumer<Throwable> onError;
    private final List<ActivePlan0> activePlans;
    private final Queue<Notification<T>> queue;
    private final AtomicBoolean subscribed = new AtomicBoolean(false);
    private final InnerObserver safeObserver;

    JoinObserver1(Observable<T> source, Consumer<Throwable> onError) {
        this.source = source;
        this.onError = onError;
        this.queue = new LinkedList<Notification<T>>();
        this.activePlans = new ArrayList<ActivePlan0>();
        this.safeObserver = new InnerObserver();
    }

    public Queue<Notification<T>> queue() {
        return this.queue;
    }

    public void addActivePlan(ActivePlan0 activePlan) {
        this.activePlans.add(activePlan);
    }

    @Override
    public void subscribe(Object gate) {
        if (!this.subscribed.compareAndSet(false, true)) {
            throw new IllegalStateException("Can only be subscribed to once.");
        }
        this.gate = gate;
        this.source.materialize().subscribe((Observer)this);
    }

    @Override
    public void dequeue() {
        this.queue.remove();
    }

    public void onNext(Notification<T> args) {
        this.safeObserver.onNext(args);
    }

    public void onError(Throwable e) {
        this.safeObserver.onError(e);
    }

    public void onComplete() {
        this.safeObserver.onComplete();
    }

    void removeActivePlan(ActivePlan0 activePlan) {
        this.activePlans.remove(activePlan);
        if (this.activePlans.isEmpty()) {
            this.dispose();
        }
    }

    public void onSubscribe(Disposable d) {
        this.safeObserver.onSubscribe(d);
    }

    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)((Disposable)this.safeObserver.get()));
    }

    public void dispose() {
        DisposableHelper.dispose((AtomicReference)this.safeObserver);
    }

    final class InnerObserver
    extends AtomicReference<Disposable>
    implements Observer<Notification<T>> {
        private static final long serialVersionUID = -1466017793444404254L;

        InnerObserver() {
        }

        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce((AtomicReference)this, (Disposable)d);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(Notification<T> args) {
            Object object = JoinObserver1.this.gate;
            synchronized (object) {
                if (!DisposableHelper.isDisposed((Disposable)((Disposable)this.get()))) {
                    if (args.isOnError()) {
                        try {
                            JoinObserver1.this.onError.accept((Object)args.getError());
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{args.getError(), ex}));
                        }
                        return;
                    }
                    JoinObserver1.this.queue.add(args);
                    for (ActivePlan0 a : new ArrayList(JoinObserver1.this.activePlans)) {
                        try {
                            a.match();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            try {
                                JoinObserver1.this.onError.accept((Object)ex);
                            }
                            catch (Throwable ex2) {
                                Exceptions.throwIfFatal((Throwable)ex2);
                                RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{ex, ex2}));
                                return;
                            }
                        }
                    }
                }
            }
        }

        public void onError(Throwable e) {
        }

        public void onComplete() {
        }
    }
}

