/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.math;

import hu.akarnokd.rxjava3.math.FlowableSource;
import io.reactivex.rxjava3.internal.subscribers.DeferredScalarSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableAverageFloat
extends FlowableSource<Number, Float> {
    FlowableAverageFloat(Publisher<Number> source) {
        super(source);
    }

    protected void subscribeActual(Subscriber<? super Float> subscriber) {
        this.source.subscribe((Subscriber)new AverageFloatSubscriber(subscriber));
    }

    static final class AverageFloatSubscriber
    extends DeferredScalarSubscriber<Number, Float> {
        private static final long serialVersionUID = 600979972678601618L;
        float accumulator;
        int count;

        AverageFloatSubscriber(Subscriber<? super Float> downstream) {
            super(downstream);
        }

        public void onNext(Number value) {
            this.accumulator += value.floatValue();
            ++this.count;
        }

        public void onComplete() {
            int c = this.count;
            if (c != 0) {
                this.complete(Float.valueOf(this.accumulator / (float)c));
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

