/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.math;

import hu.akarnokd.rxjava3.math.FlowableSource;
import io.reactivex.rxjava3.internal.subscribers.DeferredScalarSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableSumFloat
extends FlowableSource<Float, Float> {
    FlowableSumFloat(Publisher<Float> source) {
        super(source);
    }

    protected void subscribeActual(Subscriber<? super Float> subscriber) {
        this.source.subscribe((Subscriber)new SumFloatSubscriber(subscriber));
    }

    static final class SumFloatSubscriber
    extends DeferredScalarSubscriber<Float, Float> {
        private static final long serialVersionUID = 600979972678601618L;
        float accumulator;

        SumFloatSubscriber(Subscriber<? super Float> downstream) {
            super(downstream);
        }

        public void onNext(Float value) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.accumulator += value.floatValue();
        }

        public void onComplete() {
            if (this.hasValue) {
                this.complete(Float.valueOf(this.accumulator));
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

