/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.math;

import hu.akarnokd.rxjava3.math.FlowableAverageDouble;
import hu.akarnokd.rxjava3.math.FlowableAverageFloat;
import hu.akarnokd.rxjava3.math.FlowableMinMax;
import hu.akarnokd.rxjava3.math.FlowableSumDouble;
import hu.akarnokd.rxjava3.math.FlowableSumFloat;
import hu.akarnokd.rxjava3.math.FlowableSumInt;
import hu.akarnokd.rxjava3.math.FlowableSumLong;
import hu.akarnokd.rxjava3.util.SelfComparator;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Comparator;
import org.reactivestreams.Publisher;

public final class MathFlowable {
    private MathFlowable() {
        throw new IllegalStateException("No instances!");
    }

    public static Flowable<Integer> sumInt(Publisher<Integer> source) {
        return RxJavaPlugins.onAssembly((Flowable)new FlowableSumInt(source));
    }

    public static Flowable<Long> sumLong(Publisher<Long> source) {
        return RxJavaPlugins.onAssembly((Flowable)new FlowableSumLong(source));
    }

    public static Flowable<Float> sumFloat(Publisher<Float> source) {
        return RxJavaPlugins.onAssembly((Flowable)new FlowableSumFloat(source));
    }

    public static Flowable<Double> sumDouble(Publisher<Double> source) {
        return RxJavaPlugins.onAssembly((Flowable)new FlowableSumDouble(source));
    }

    public static <T extends Comparable<? super T>> Flowable<T> max(Publisher<T> source) {
        Comparator comp = SelfComparator.instance();
        return MathFlowable.max(source, comp);
    }

    public static <T> Flowable<T> max(Publisher<T> source, Comparator<? super T> comparator) {
        return RxJavaPlugins.onAssembly(new FlowableMinMax<T>(source, comparator, -1));
    }

    public static <T extends Comparable<? super T>> Flowable<T> min(Publisher<T> source) {
        Comparator comp = SelfComparator.instance();
        return MathFlowable.min(source, comp);
    }

    public static <T> Flowable<T> min(Publisher<T> source, Comparator<? super T> comparator) {
        return RxJavaPlugins.onAssembly(new FlowableMinMax<T>(source, comparator, 1));
    }

    public static Flowable<Float> averageFloat(Publisher<? extends Number> source) {
        return RxJavaPlugins.onAssembly((Flowable)new FlowableAverageFloat((Publisher<Number>)source));
    }

    public static Flowable<Double> averageDouble(Publisher<? extends Number> source) {
        return RxJavaPlugins.onAssembly((Flowable)new FlowableAverageDouble((Publisher<Number>)source));
    }
}

