/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.math;

import hu.akarnokd.rxjava3.math.ObservableAverageDouble;
import hu.akarnokd.rxjava3.math.ObservableAverageFloat;
import hu.akarnokd.rxjava3.math.ObservableMinMax;
import hu.akarnokd.rxjava3.math.ObservableSumDouble;
import hu.akarnokd.rxjava3.math.ObservableSumFloat;
import hu.akarnokd.rxjava3.math.ObservableSumInt;
import hu.akarnokd.rxjava3.math.ObservableSumLong;
import hu.akarnokd.rxjava3.util.SelfComparator;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Comparator;

public final class MathObservable {
    private MathObservable() {
        throw new IllegalStateException("No instances!");
    }

    public static Observable<Integer> sumInt(ObservableSource<Integer> source) {
        return RxJavaPlugins.onAssembly((Observable)new ObservableSumInt(source));
    }

    public static Observable<Long> sumLong(ObservableSource<Long> source) {
        return RxJavaPlugins.onAssembly((Observable)new ObservableSumLong(source));
    }

    public static Observable<Float> sumFloat(ObservableSource<Float> source) {
        return RxJavaPlugins.onAssembly((Observable)new ObservableSumFloat(source));
    }

    public static Observable<Double> sumDouble(ObservableSource<Double> source) {
        return RxJavaPlugins.onAssembly((Observable)new ObservableSumDouble(source));
    }

    public static <T extends Comparable<? super T>> Observable<T> max(ObservableSource<T> source) {
        Comparator comp = SelfComparator.instance();
        return MathObservable.max(source, comp);
    }

    public static <T> Observable<T> max(ObservableSource<T> source, Comparator<? super T> comparator) {
        return RxJavaPlugins.onAssembly(new ObservableMinMax<T>(source, comparator, -1));
    }

    public static <T extends Comparable<? super T>> Observable<T> min(ObservableSource<T> source) {
        Comparator comp = SelfComparator.instance();
        return MathObservable.min(source, comp);
    }

    public static <T> Observable<T> min(ObservableSource<T> source, Comparator<? super T> comparator) {
        return RxJavaPlugins.onAssembly(new ObservableMinMax<T>(source, comparator, 1));
    }

    public static Observable<Float> averageFloat(ObservableSource<? extends Number> source) {
        return RxJavaPlugins.onAssembly((Observable)new ObservableAverageFloat((ObservableSource<Number>)source));
    }

    public static Observable<Double> averageDouble(ObservableSource<? extends Number> source) {
        return RxJavaPlugins.onAssembly((Observable)new ObservableAverageDouble((ObservableSource<Number>)source));
    }
}

