/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.math;

import hu.akarnokd.rxjava3.math.ObservableWithSource;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.internal.observers.DeferredScalarObserver;

public class ObservableAverageDouble
extends ObservableWithSource<Number, Double> {
    public ObservableAverageDouble(ObservableSource<Number> source) {
        super(source);
    }

    protected void subscribeActual(Observer<? super Double> observer) {
        this.source.subscribe((Observer)new AverageDoubleObserver(observer));
    }

    static final class AverageDoubleObserver
    extends DeferredScalarObserver<Number, Double> {
        private static final long serialVersionUID = 6990557227019180008L;
        double accumulator;
        long count;

        AverageDoubleObserver(Observer<? super Double> downstream) {
            super(downstream);
        }

        public void onNext(Number value) {
            ++this.count;
            this.accumulator += value.doubleValue();
        }

        public void onComplete() {
            long c = this.count;
            if (c != 0L) {
                this.complete(this.accumulator / (double)c);
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

