/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.math;

import hu.akarnokd.rxjava3.math.ObservableWithSource;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.internal.observers.DeferredScalarObserver;

public class ObservableAverageFloat
extends ObservableWithSource<Number, Float> {
    public ObservableAverageFloat(ObservableSource<Number> source) {
        super(source);
    }

    protected void subscribeActual(Observer<? super Float> observer) {
        this.source.subscribe((Observer)new AverageFloatObserver(observer));
    }

    static final class AverageFloatObserver
    extends DeferredScalarObserver<Number, Float> {
        private static final long serialVersionUID = -4845767048730060914L;
        float accumulator;
        int count;

        AverageFloatObserver(Observer<? super Float> downstream) {
            super(downstream);
        }

        public void onNext(Number value) {
            ++this.count;
            this.accumulator += value.floatValue();
        }

        public void onComplete() {
            int c = this.count;
            if (c != 0) {
                this.complete(Float.valueOf(this.accumulator / (float)c));
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

