/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.math;

import hu.akarnokd.rxjava3.math.ObservableWithSource;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.internal.observers.DeferredScalarObserver;

public class ObservableSumFloat
extends ObservableWithSource<Float, Float> {
    public ObservableSumFloat(ObservableSource<Float> source) {
        super(source);
    }

    protected void subscribeActual(Observer<? super Float> observer) {
        this.source.subscribe((Observer)new SumFloatObserver(observer));
    }

    static final class SumFloatObserver
    extends DeferredScalarObserver<Float, Float> {
        private static final long serialVersionUID = -6344890278713820111L;
        float accumulator;
        boolean hasValue;

        SumFloatObserver(Observer<? super Float> downstream) {
            super(downstream);
        }

        public void onNext(Float value) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.accumulator += value.floatValue();
        }

        public void onComplete() {
            if (this.hasValue) {
                this.complete(Float.valueOf(this.accumulator));
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

