/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.math;

import hu.akarnokd.rxjava3.math.ObservableWithSource;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.internal.observers.DeferredScalarObserver;

public class ObservableSumLong
extends ObservableWithSource<Long, Long> {
    public ObservableSumLong(ObservableSource<Long> source) {
        super(source);
    }

    protected void subscribeActual(Observer<? super Long> observer) {
        this.source.subscribe((Observer)new SumLongObserver(observer));
    }

    static final class SumLongObserver
    extends DeferredScalarObserver<Long, Long> {
        private static final long serialVersionUID = 8645575082613773782L;
        long accumulator;
        boolean hasValue;

        SumLongObserver(Observer<? super Long> downstream) {
            super(downstream);
        }

        public void onNext(Long value) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.accumulator += value.longValue();
        }

        public void onComplete() {
            if (this.hasValue) {
                this.complete(this.accumulator);
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

