/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.fuseable.SimpleQueue;
import io.reactivex.rxjava3.internal.subscribers.InnerQueuedSubscriber;
import io.reactivex.rxjava3.internal.subscribers.InnerQueuedSubscriberSupport;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class BasicMergeSubscription<T>
extends AtomicInteger
implements Subscription,
InnerQueuedSubscriberSupport<T> {
    private static final long serialVersionUID = -8467324377226330554L;
    final Subscriber<? super T> downstream;
    final Comparator<? super T> comparator;
    final InnerQueuedSubscriber<T>[] subscribers;
    final boolean delayErrors;
    final AtomicThrowable errors;
    final AtomicLong requested;
    final Object[] latest;
    volatile boolean cancelled;

    public BasicMergeSubscription(Subscriber<? super T> downstream, Comparator<? super T> comparator, int n, int prefetch, boolean delayErrors) {
        this.downstream = downstream;
        this.comparator = comparator;
        this.delayErrors = delayErrors;
        InnerQueuedSubscriber[] subs = new InnerQueuedSubscriber[n];
        for (int i = 0; i < n; ++i) {
            subs[i] = new InnerQueuedSubscriber((InnerQueuedSubscriberSupport)this, prefetch);
        }
        this.subscribers = subs;
        this.requested = new AtomicLong();
        this.errors = new AtomicThrowable();
        this.latest = new Object[n];
    }

    public void subscribe(Publisher<T>[] sources, int n) {
        InnerQueuedSubscriber<T>[] subs = this.subscribers;
        for (int i = 0; i < n && !this.cancelled; ++i) {
            Publisher<T> p = sources[i];
            if (p != null) {
                p.subscribe(subs[i]);
                continue;
            }
            EmptySubscription.error((Throwable)new NullPointerException("The " + i + "th source is null"), subs[i]);
            if (!this.delayErrors) break;
        }
    }

    public void subscribe(ParallelFlowable<T> source) {
        source.subscribe(this.subscribers);
    }

    public void request(long n) {
        if (SubscriptionHelper.validate((long)n)) {
            BackpressureHelper.add((AtomicLong)this.requested, (long)n);
            this.drain();
        }
    }

    void cancelSources() {
        for (InnerQueuedSubscriber<T> d : this.subscribers) {
            d.cancel();
        }
    }

    void clearSources() {
        Arrays.fill(this.latest, this);
        for (InnerQueuedSubscriber<T> d : this.subscribers) {
            SimpleQueue q = d.queue();
            if (q == null) continue;
            q.clear();
        }
    }

    void cancelAndClearSources() {
        Arrays.fill(this.latest, this);
        for (InnerQueuedSubscriber<T> d : this.subscribers) {
            d.cancel();
            SimpleQueue q = d.queue();
            if (q == null) continue;
            q.clear();
        }
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.cancelSources();
            this.errors.tryTerminateAndReport();
            if (this.getAndIncrement() == 0) {
                this.clearSources();
            }
        }
    }

    public void innerNext(InnerQueuedSubscriber<T> inner, T value) {
        inner.queue().offer(value);
        this.drain();
    }

    public void innerError(InnerQueuedSubscriber<T> inner, Throwable e) {
        if (this.errors.tryAddThrowableOrReport(e)) {
            if (!this.delayErrors) {
                this.cancelSources();
            } else {
                inner.setDone();
            }
            this.drain();
        }
    }

    public void innerComplete(InnerQueuedSubscriber<T> inner) {
        inner.setDone();
        this.drain();
    }

    public void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Subscriber<? super T> a = this.downstream;
        AtomicThrowable err = this.errors;
        InnerQueuedSubscriber<T>[] subs = this.subscribers;
        int n = subs.length;
        Object[] latest = this.latest;
        Comparator<Object> comp = this.comparator;
        do {
            boolean d;
            long e;
            long r = this.requested.get();
            for (e = 0L; e != r; ++e) {
                if (this.cancelled) {
                    this.clearSources();
                    return;
                }
                if (!this.delayErrors && err.get() != null) {
                    this.cancelAndClearSources();
                    a.onError(err.terminate());
                    return;
                }
                d = true;
                int hasValue = 0;
                boolean empty = true;
                Object smallest = null;
                int pick = -1;
                for (int i = 0; i < n; ++i) {
                    boolean smaller;
                    Object v;
                    InnerQueuedSubscriber<T> inner = subs[i];
                    boolean innerDone = inner.isDone();
                    if (!innerDone) {
                        d = false;
                    }
                    if ((v = latest[i]) == null) {
                        SimpleQueue q = inner.queue();
                        try {
                            v = q != null ? q.poll() : null;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            err.tryAddThrowableOrReport(ex);
                            inner.setDone();
                            if (!this.delayErrors) {
                                this.cancelAndClearSources();
                                err.tryTerminateConsumer(a);
                                return;
                            }
                            v = this;
                        }
                        if (v != null) {
                            latest[i] = v;
                            ++hasValue;
                            empty = false;
                        } else if (innerDone) {
                            latest[i] = this;
                            ++hasValue;
                        }
                    } else {
                        ++hasValue;
                        if (v != this) {
                            empty = false;
                        }
                    }
                    if (v == null || v == this) continue;
                    try {
                        smaller = smallest != null ? comp.compare(smallest, v) > 0 : true;
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        err.tryAddThrowableOrReport(ex);
                        this.cancelAndClearSources();
                        a.onError(err.terminate());
                        return;
                    }
                    if (!smaller) continue;
                    smallest = v;
                    pick = i;
                }
                if (hasValue == n && pick >= 0) {
                    a.onNext(smallest);
                    latest[pick] = null;
                    subs[pick].request(1L);
                    continue;
                }
                if (!d || !empty) break;
                if (err.get() != null) {
                    a.onError(err.terminate());
                } else {
                    a.onComplete();
                }
                return;
            }
            if (e == r) {
                if (this.cancelled) {
                    this.clearSources();
                    return;
                }
                if (!this.delayErrors && err.get() != null) {
                    this.cancelAndClearSources();
                    a.onError(err.terminate());
                    return;
                }
                d = true;
                boolean empty = true;
                for (int i = 0; i < subs.length; ++i) {
                    InnerQueuedSubscriber<T> inner = subs[i];
                    if (!inner.isDone()) {
                        d = false;
                        break;
                    }
                    Object o = latest[i];
                    SimpleQueue q = inner.queue();
                    if (o == null && q != null) {
                        try {
                            o = q.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            err.tryAddThrowableOrReport(ex);
                            if (!this.delayErrors) {
                                this.cancelAndClearSources();
                                err.tryTerminateConsumer(a);
                                return;
                            }
                            o = this;
                        }
                        latest[i] = o;
                    }
                    if (o == null || o == this) continue;
                    empty = false;
                    break;
                }
                if (d && empty) {
                    if (err.get() != null) {
                        a.onError(err.terminate());
                    } else {
                        a.onComplete();
                    }
                    return;
                }
            }
            if (e == 0L) continue;
            BackpressureHelper.produced((AtomicLong)this.requested, (long)e);
        } while ((missed = this.addAndGet(-missed)) != 0);
    }
}

