/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

final class CompletableFlatMapSignalCompletable
extends Completable
implements CompletableTransformer {
    final Completable source;
    final Supplier<? extends CompletableSource> onCompleteHandler;
    final Function<? super Throwable, ? extends CompletableSource> onErrorHandler;

    CompletableFlatMapSignalCompletable(Completable source, Supplier<? extends CompletableSource> onCompleteHandler, Function<? super Throwable, ? extends CompletableSource> onErrorHandler) {
        this.source = source;
        this.onCompleteHandler = onCompleteHandler;
        this.onErrorHandler = onErrorHandler;
    }

    public CompletableSource apply(Completable upstream) {
        return new CompletableFlatMapSignalCompletable(upstream, this.onCompleteHandler, this.onErrorHandler);
    }

    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe((CompletableObserver)new FlatMapSignalConsumer(observer, this.onCompleteHandler, this.onErrorHandler));
    }

    static final class FlatMapSignalConsumer
    implements CompletableObserver,
    Disposable {
        final SignalConsumer consumer;
        final Supplier<? extends CompletableSource> onCompleteHandler;
        final Function<? super Throwable, ? extends CompletableSource> onErrorHandler;

        FlatMapSignalConsumer(CompletableObserver downstream, Supplier<? extends CompletableSource> onCompleteHandler, Function<? super Throwable, ? extends CompletableSource> onErrorHandler) {
            this.consumer = new SignalConsumer(downstream);
            this.onCompleteHandler = onCompleteHandler;
            this.onErrorHandler = onErrorHandler;
        }

        public void dispose() {
            DisposableHelper.dispose((AtomicReference)this.consumer);
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.consumer.get()));
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)((Disposable)this.consumer.get()), (Disposable)d)) {
                this.consumer.lazySet(d);
                this.consumer.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onComplete() {
            CompletableSource next;
            try {
                next = (CompletableSource)Objects.requireNonNull(this.onCompleteHandler.get(), "The onCompleteHandler returned a null CompletableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe((CompletableObserver)this.consumer);
        }

        public void onError(Throwable e) {
            CompletableSource next;
            try {
                next = (CompletableSource)Objects.requireNonNull(this.onErrorHandler.apply((Object)e), "The onErrorHandler returned a null CompletableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe((CompletableObserver)this.consumer);
        }

        static final class SignalConsumer
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = 314442824941893429L;
            final CompletableObserver downstream;

            SignalConsumer(CompletableObserver downstream) {
                this.downstream = downstream;
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.replace((AtomicReference)this, (Disposable)d);
            }

            public void onComplete() {
                this.downstream.onComplete();
            }

            public void onError(Throwable e) {
                this.downstream.onError(e);
            }
        }
    }
}

