/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableConverter;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

final class CompletableFlatMapSignalObservable<R>
extends Observable<R>
implements CompletableConverter<Observable<R>> {
    final Completable source;
    final Supplier<? extends ObservableSource<? extends R>> onCompleteHandler;
    final Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler;

    CompletableFlatMapSignalObservable(Completable source, Supplier<? extends ObservableSource<? extends R>> onCompleteHandler, Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler) {
        this.source = source;
        this.onCompleteHandler = onCompleteHandler;
        this.onErrorHandler = onErrorHandler;
    }

    public Observable<R> apply(Completable t) {
        return new CompletableFlatMapSignalObservable<R>(t, this.onCompleteHandler, this.onErrorHandler);
    }

    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new FlatMapSignalConsumer<R>(observer, this.onCompleteHandler, this.onErrorHandler));
    }

    static final class FlatMapSignalConsumer<R>
    implements CompletableObserver,
    Disposable {
        final SignalConsumer<R> consumer;
        final Supplier<? extends ObservableSource<? extends R>> onCompleteHandler;
        final Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler;

        FlatMapSignalConsumer(Observer<? super R> downstream, Supplier<? extends ObservableSource<? extends R>> onCompleteHandler, Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler) {
            this.consumer = new SignalConsumer<R>(downstream);
            this.onCompleteHandler = onCompleteHandler;
            this.onErrorHandler = onErrorHandler;
        }

        public void dispose() {
            DisposableHelper.dispose(this.consumer);
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.consumer.get()));
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)((Disposable)this.consumer.get()), (Disposable)d)) {
                this.consumer.lazySet(d);
                this.consumer.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onComplete() {
            ObservableSource next;
            try {
                next = (ObservableSource)Objects.requireNonNull(this.onCompleteHandler.get(), "The onCompleteHandler returned a null ObservableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        public void onError(Throwable e) {
            ObservableSource next;
            try {
                next = (ObservableSource)Objects.requireNonNull(this.onErrorHandler.apply((Object)e), "The onErrorHandler returned a null ObservableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        static final class SignalConsumer<R>
        extends AtomicReference<Disposable>
        implements Observer<R> {
            private static final long serialVersionUID = 314442824941893429L;
            final Observer<? super R> downstream;

            SignalConsumer(Observer<? super R> downstream) {
                this.downstream = downstream;
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.replace((AtomicReference)this, (Disposable)d);
            }

            public void onNext(R t) {
                this.downstream.onNext(t);
            }

            public void onComplete() {
                this.downstream.onComplete();
            }

            public void onError(Throwable e) {
                this.downstream.onError(e);
            }
        }
    }
}

