/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.fuseable.ConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableBufferPredicate<T, C extends Collection<? super T>>
extends Flowable<C>
implements FlowableTransformer<T, C> {
    final Publisher<T> source;
    final Predicate<? super T> predicate;
    final Mode mode;
    final Supplier<C> bufferSupplier;

    FlowableBufferPredicate(Publisher<T> source, Predicate<? super T> predicate, Mode mode, Supplier<C> bufferSupplier) {
        this.source = source;
        this.predicate = predicate;
        this.mode = mode;
        this.bufferSupplier = bufferSupplier;
    }

    protected void subscribeActual(Subscriber<? super C> s) {
        Collection buffer;
        try {
            buffer = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        this.source.subscribe(new BufferPredicateSubscriber<T, Collection>(s, buffer, this.predicate, this.mode, this.bufferSupplier));
    }

    public Publisher<C> apply(Flowable<T> upstream) {
        return new FlowableBufferPredicate<T, C>(upstream, this.predicate, this.mode, this.bufferSupplier);
    }

    static final class BufferPredicateSubscriber<T, C extends Collection<? super T>>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Subscriber<? super C> downstream;
        final Predicate<? super T> predicate;
        final Mode mode;
        final Supplier<C> bufferSupplier;
        C buffer;
        Subscription upstream;
        int count;

        BufferPredicateSubscriber(Subscriber<? super C> downstream, C buffer, Predicate<? super T> predicate, Mode mode, Supplier<C> bufferSupplier) {
            this.downstream = downstream;
            this.predicate = predicate;
            this.mode = mode;
            this.buffer = buffer;
            this.bufferSupplier = bufferSupplier;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            Object buf = this.buffer;
            if (buf != null) {
                boolean b;
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.upstream.cancel();
                    this.buffer = null;
                    this.downstream.onError(ex);
                    return true;
                }
                switch (this.mode) {
                    case AFTER: {
                        buf.add(t);
                        if (b) {
                            this.downstream.onNext(buf);
                            try {
                                this.buffer = (Collection)this.bufferSupplier.get();
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal((Throwable)ex);
                                this.upstream.cancel();
                                this.onError(ex);
                                return true;
                            }
                            this.count = 0;
                            break;
                        }
                        ++this.count;
                        return false;
                    }
                    case BEFORE: {
                        if (b) {
                            buf.add(t);
                            ++this.count;
                            return false;
                        }
                        this.downstream.onNext(buf);
                        try {
                            buf = (Collection)this.bufferSupplier.get();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            this.upstream.cancel();
                            this.onError(ex);
                            return true;
                        }
                        buf.add(t);
                        this.buffer = buf;
                        this.count = 1;
                        break;
                    }
                    default: {
                        if (b) {
                            this.downstream.onNext(buf);
                            try {
                                this.buffer = (Collection)this.bufferSupplier.get();
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal((Throwable)ex);
                                this.upstream.cancel();
                                this.onError(ex);
                                return true;
                            }
                            this.count = 0;
                            break;
                        }
                        buf.add(t);
                        ++this.count;
                        return false;
                    }
                }
            }
            return true;
        }

        public void onError(Throwable t) {
            if (this.buffer != null) {
                this.buffer = null;
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            C b = this.buffer;
            if (b != null) {
                this.buffer = null;
                if (this.count != 0) {
                    this.downstream.onNext(b);
                }
                this.downstream.onComplete();
            }
        }

        public void request(long n) {
            this.upstream.request(n);
        }

        public void cancel() {
            this.upstream.cancel();
        }
    }

    static enum Mode {
        BEFORE,
        AFTER,
        SPLIT;

    }
}

