/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableEvery<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Publisher<T> source;
    final long keep;

    FlowableEvery(Publisher<T> source, long keep) {
        this.source = source;
        this.keep = keep;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new EverySubscriber<T>(s, this.keep));
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableEvery<T>(upstream, this.keep);
    }

    static final class EverySubscriber<T>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super T> downstream;
        final long keep;
        long index;
        Subscription upstream;

        EverySubscriber(Subscriber<? super T> downstream, long keep) {
            this.downstream = downstream;
            this.keep = keep;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            long i = this.index + 1L;
            if (i == this.keep) {
                this.index = 0L;
                this.downstream.onNext(t);
            } else {
                this.index = i;
            }
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                long u = BackpressureHelper.multiplyCap((long)n, (long)this.keep);
                this.upstream.request(u);
            }
        }

        public void cancel() {
            this.upstream.cancel();
        }
    }
}

