/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import hu.akarnokd.rxjava3.operators.ExpandStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.fuseable.SimplePlainQueue;
import io.reactivex.rxjava3.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableExpand<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Flowable<T> source;
    final Function<? super T, ? extends Publisher<? extends T>> expander;
    final ExpandStrategy strategy;
    final int capacityHint;
    final boolean delayErrors;

    FlowableExpand(Flowable<T> source, Function<? super T, ? extends Publisher<? extends T>> expander, ExpandStrategy strategy, int capacityHint, boolean delayErrors) {
        this.source = source;
        this.expander = expander;
        this.strategy = strategy;
        this.capacityHint = capacityHint;
        this.delayErrors = delayErrors;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        if (this.strategy != ExpandStrategy.DEPTH_FIRST) {
            ExpandBreadthSubscriber<T> parent = new ExpandBreadthSubscriber<T>(s, this.expander, this.capacityHint, this.delayErrors);
            parent.queue.offer(this.source);
            s.onSubscribe(parent);
            parent.drainQueue();
        } else {
            ExpandDepthSubscription<? super T> parent = new ExpandDepthSubscription<T>(s, this.expander, this.capacityHint, this.delayErrors);
            parent.source = this.source;
            s.onSubscribe(parent);
        }
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableExpand<T>(upstream, this.expander, this.strategy, this.capacityHint, this.delayErrors);
    }

    static final class ExpandDepthSubscription<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = -2126738751597075165L;
        final Subscriber<? super T> downstream;
        final Function<? super T, ? extends Publisher<? extends T>> expander;
        final AtomicThrowable error;
        final AtomicInteger active;
        final AtomicLong requested;
        final AtomicReference<Object> current;
        final boolean delayErrors;
        ArrayDeque<ExpandDepthSubscriber> subscriptionStack;
        volatile boolean cancelled;
        Publisher<? extends T> source;
        long consumed;

        ExpandDepthSubscription(Subscriber<? super T> downstream, Function<? super T, ? extends Publisher<? extends T>> expander, int capacityHint, boolean delayErrors) {
            this.downstream = downstream;
            this.expander = expander;
            this.subscriptionStack = new ArrayDeque();
            this.error = new AtomicThrowable();
            this.active = new AtomicInteger();
            this.requested = new AtomicLong();
            this.current = new AtomicReference();
            this.delayErrors = delayErrors;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drainQueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            if (!this.cancelled) {
                Object o;
                ArrayDeque<ExpandDepthSubscriber> q;
                this.cancelled = true;
                ExpandDepthSubscription expandDepthSubscription = this;
                synchronized (expandDepthSubscription) {
                    q = this.subscriptionStack;
                    this.subscriptionStack = null;
                }
                if (q != null) {
                    while (!q.isEmpty()) {
                        q.poll().dispose();
                    }
                }
                if ((o = this.current.getAndSet(this)) != this && o != null) {
                    ((ExpandDepthSubscriber)o).dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ExpandDepthSubscriber pop() {
            ExpandDepthSubscription expandDepthSubscription = this;
            synchronized (expandDepthSubscription) {
                ArrayDeque<ExpandDepthSubscriber> q = this.subscriptionStack;
                return q != null ? q.pollFirst() : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean push(ExpandDepthSubscriber subscriber) {
            ExpandDepthSubscription expandDepthSubscription = this;
            synchronized (expandDepthSubscription) {
                ArrayDeque<ExpandDepthSubscriber> q = this.subscriptionStack;
                if (q != null) {
                    q.offerFirst(subscriber);
                    return true;
                }
                return false;
            }
        }

        boolean setCurrent(ExpandDepthSubscriber inner) {
            Object o;
            do {
                if ((o = this.current.get()) != this) continue;
                if (inner != null) {
                    inner.dispose();
                }
                return false;
            } while (!this.current.compareAndSet(o, inner));
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void drainQueue() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<? super T> a = this.downstream;
            long e = this.consumed;
            AtomicInteger n = this.active;
            while (true) {
                int w;
                Object o = this.current.get();
                if (this.cancelled || o == this) {
                    this.source = null;
                    return;
                }
                ExpandDepthSubscriber curr = (ExpandDepthSubscriber)o;
                Publisher p = this.source;
                if (curr == null && p != null) {
                    ExpandDepthSubscriber eds;
                    this.source = null;
                    n.getAndIncrement();
                    curr = eds = new ExpandDepthSubscriber();
                    if (!this.setCurrent(eds)) return;
                    p.subscribe((Subscriber)eds);
                } else {
                    boolean currentDone = curr.done;
                    if (!this.delayErrors && this.error.get() != null) {
                        this.cancel();
                        this.error.tryTerminateConsumer(a);
                        return;
                    }
                    Object v = curr.value;
                    boolean newSource = false;
                    if (v != null && e != this.requested.get()) {
                        curr.value = null;
                        a.onNext(v);
                        ++e;
                        try {
                            p = (Publisher)Objects.requireNonNull(this.expander.apply(v), "The expander returned a null Publisher");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            p = null;
                            curr.dispose();
                            curr.done = true;
                            currentDone = true;
                            v = null;
                            this.error.tryAddThrowableOrReport(ex);
                        }
                        if (p != null && this.push(curr)) {
                            n.getAndIncrement();
                            curr = new ExpandDepthSubscriber();
                            if (!this.setCurrent(curr)) return;
                            p.subscribe((Subscriber)curr);
                            newSource = true;
                        }
                    }
                    if (!newSource && currentDone && v == null) {
                        if (n.decrementAndGet() == 0) {
                            this.error.tryTerminateConsumer(a);
                            return;
                        }
                        curr = this.pop();
                        if (curr == null || !this.setCurrent(curr)) return;
                        curr.requestOne();
                        continue;
                    }
                }
                if (missed == (w = this.get())) {
                    this.consumed = e;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    return;
                }
                missed = w;
            }
        }

        void innerNext(ExpandDepthSubscriber inner, T t) {
            this.drainQueue();
        }

        void innerError(ExpandDepthSubscriber inner, Throwable t) {
            this.error.tryAddThrowableOrReport(t);
            inner.done = true;
            this.drainQueue();
        }

        void innerComplete(ExpandDepthSubscriber inner) {
            inner.done = true;
            this.drainQueue();
        }

        final class ExpandDepthSubscriber
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<T> {
            private static final long serialVersionUID = 4198645419772153739L;
            volatile boolean done;
            volatile T value;

            ExpandDepthSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(1L);
                }
            }

            public void onNext(T t) {
                if (SubscriptionHelper.CANCELLED != this.get()) {
                    this.value = t;
                    ExpandDepthSubscription.this.innerNext(this, t);
                }
            }

            public void onError(Throwable t) {
                if (SubscriptionHelper.CANCELLED != this.get()) {
                    ExpandDepthSubscription.this.innerError(this, t);
                }
            }

            public void onComplete() {
                if (SubscriptionHelper.CANCELLED != this.get()) {
                    ExpandDepthSubscription.this.innerComplete(this);
                }
            }

            public void requestOne() {
                ((Subscription)this.get()).request(1L);
            }

            public void dispose() {
                SubscriptionHelper.cancel((AtomicReference)this);
            }
        }
    }

    static final class ExpandBreadthSubscriber<T>
    extends SubscriptionArbiter
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -8200116117441115256L;
        final Subscriber<? super T> downstream;
        final Function<? super T, ? extends Publisher<? extends T>> expander;
        final SimplePlainQueue<Publisher<? extends T>> queue;
        final AtomicInteger wip;
        final boolean delayErrors;
        final AtomicThrowable errors;
        volatile boolean active;
        long produced;

        ExpandBreadthSubscriber(Subscriber<? super T> downstream, Function<? super T, ? extends Publisher<? extends T>> expander, int capacityHint, boolean delayErrors) {
            super(false);
            this.downstream = downstream;
            this.expander = expander;
            this.wip = new AtomicInteger();
            this.queue = new SpscLinkedArrayQueue(capacityHint);
            this.errors = new AtomicThrowable();
            this.delayErrors = delayErrors;
        }

        public void onSubscribe(Subscription s) {
            this.setSubscription(s);
        }

        public void onNext(T t) {
            Publisher p;
            ++this.produced;
            this.downstream.onNext(t);
            try {
                p = (Publisher)Objects.requireNonNull(this.expander.apply(t), "The expander returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                super.cancel();
                this.downstream.onError(ex);
                this.drainQueue();
                return;
            }
            this.queue.offer((Object)p);
        }

        public void onError(Throwable t) {
            this.setSubscription((Subscription)SubscriptionHelper.CANCELLED);
            if (this.delayErrors) {
                this.errors.tryAddThrowableOrReport(t);
                this.active = false;
            } else {
                super.cancel();
                this.downstream.onError(t);
            }
            this.drainQueue();
        }

        public void onComplete() {
            this.active = false;
            this.drainQueue();
        }

        public void cancel() {
            super.cancel();
            this.errors.tryTerminateAndReport();
            this.drainQueue();
        }

        void drainQueue() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    SimplePlainQueue<Publisher<? extends T>> q = this.queue;
                    if (this.isCancelled()) {
                        q.clear();
                        continue;
                    }
                    if (this.active) continue;
                    if (q.isEmpty()) {
                        this.setSubscription((Subscription)SubscriptionHelper.CANCELLED);
                        super.cancel();
                        this.errors.tryTerminateConsumer(this.downstream);
                        continue;
                    }
                    Publisher p = (Publisher)q.poll();
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.produced(c);
                    }
                    this.active = true;
                    p.subscribe((Subscriber)this);
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }
}

