/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import hu.akarnokd.rxjava3.operators.FlowableFlatMapSync;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.fuseable.SimpleQueue;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableFlatMapAsync<T, R>
extends Flowable<R>
implements FlowableTransformer<T, R> {
    final Publisher<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int maxConcurrency;
    final int bufferSize;
    final boolean depthFirst;
    final Scheduler scheduler;

    FlowableFlatMapAsync(Publisher<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int bufferSize, boolean depthFirst, Scheduler scheduler) {
        this.source = source;
        this.mapper = mapper;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
        this.depthFirst = depthFirst;
        this.scheduler = scheduler;
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new FlatMapOuterSubscriber<T, R>(s, this.mapper, this.maxConcurrency, this.bufferSize, this.depthFirst, this.scheduler.createWorker()));
    }

    public Publisher<R> apply(Flowable<T> upstream) {
        return new FlowableFlatMapAsync<T, R>(upstream, this.mapper, this.maxConcurrency, this.bufferSize, this.depthFirst, this.scheduler);
    }

    static final class FlatMapOuterSubscriber<T, R>
    extends FlowableFlatMapSync.BaseFlatMapOuterSubscriber<T, R>
    implements Runnable {
        private static final long serialVersionUID = -5109342841608286301L;
        final Scheduler.Worker worker;

        FlatMapOuterSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int bufferSize, boolean depthFirst, Scheduler.Worker worker) {
            super(downstream, mapper, maxConcurrency, bufferSize, depthFirst);
            this.worker = worker;
        }

        @Override
        public void drain() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule((Runnable)this);
            }
        }

        @Override
        public void run() {
            if (this.depthFirst) {
                this.depthFirst();
            } else {
                this.breadthFirst();
            }
        }

        @Override
        void cleanupAfter() {
            this.worker.dispose();
        }

        @Override
        public void innerNext(FlowableFlatMapSync.FlatMapInnerSubscriber<T, R> inner, R item) {
            SimpleQueue<R> q = inner.queue();
            q.offer(item);
            this.drain();
        }

        @Override
        public void innerError(FlowableFlatMapSync.FlatMapInnerSubscriber<T, R> inner, Throwable ex) {
            this.remove(inner);
            if (this.error.tryAddThrowableOrReport(ex)) {
                inner.done = true;
                this.done = true;
                this.upstream.cancel();
                this.cancelInners();
                this.drain();
            }
        }

        @Override
        public void innerComplete(FlowableFlatMapSync.FlatMapInnerSubscriber<T, R> inner) {
            inner.done = true;
            this.drain();
        }
    }
}

