/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.fuseable.QueueSubscription;
import io.reactivex.rxjava3.internal.fuseable.SimpleQueue;
import io.reactivex.rxjava3.internal.queue.SpscArrayQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.Pow2;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableFlatMapSync<T, R>
extends Flowable<R>
implements FlowableTransformer<T, R> {
    final Publisher<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int maxConcurrency;
    final int bufferSize;
    final boolean depthFirst;

    FlowableFlatMapSync(Publisher<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int bufferSize, boolean depthFirst) {
        this.source = source;
        this.mapper = mapper;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
        this.depthFirst = depthFirst;
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new FlatMapOuterSubscriber<T, R>(s, this.mapper, this.maxConcurrency, this.bufferSize, this.depthFirst));
    }

    public Publisher<R> apply(Flowable<T> upstream) {
        return new FlowableFlatMapSync<T, R>(upstream, this.mapper, this.maxConcurrency, this.bufferSize, this.depthFirst);
    }

    static final class FlatMapInnerSubscriber<T, R>
    extends AtomicReference<Subscription>
    implements Subscriber<R> {
        private static final long serialVersionUID = -4991009168975207961L;
        final FlatMapInnerSubscriberSupport<T, R> parent;
        final int bufferSize;
        final int limit;
        final int index;
        int produced;
        int fusionMode;
        volatile boolean done;
        volatile SimpleQueue<R> queue;

        FlatMapInnerSubscriber(FlatMapInnerSubscriberSupport<T, R> parent, int bufferSize, int index) {
            this.parent = parent;
            this.bufferSize = bufferSize;
            this.limit = bufferSize - (bufferSize >> 2);
            this.index = index;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(7);
                    if (m == 1) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m == 2) {
                        this.fusionMode = m;
                        this.queue = qs;
                        s.request((long)this.bufferSize);
                        return;
                    }
                }
                s.request((long)this.bufferSize);
            }
        }

        public void onNext(R t) {
            if (this.fusionMode == 0) {
                this.parent.innerNext(this, t);
            } else {
                this.parent.drain();
            }
        }

        public void onError(Throwable t) {
            this.parent.innerError(this, t);
        }

        public void onComplete() {
            this.parent.innerComplete(this);
        }

        void cancel() {
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        void producedOne() {
            if (this.fusionMode != 1) {
                int p = this.produced + 1;
                if (p == this.limit) {
                    this.produced = 0;
                    ((Subscription)this.get()).request((long)p);
                } else {
                    this.produced = p;
                }
            }
        }

        SimpleQueue<R> queue() {
            SpscArrayQueue q = this.queue;
            if (q == null) {
                this.queue = q = new SpscArrayQueue(this.bufferSize);
            }
            return q;
        }
    }

    static final class FlatMapOuterSubscriber<T, R>
    extends BaseFlatMapOuterSubscriber<T, R> {
        private static final long serialVersionUID = -5109342841608286301L;

        FlatMapOuterSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int bufferSize, boolean depthFirst) {
            super(downstream, mapper, maxConcurrency, bufferSize, depthFirst);
        }

        @Override
        public void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            if (this.depthFirst) {
                this.depthFirst();
            } else {
                this.breadthFirst();
            }
        }

        @Override
        void cleanupAfter() {
        }

        @Override
        public void innerNext(FlatMapInnerSubscriber<T, R> inner, R item) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long e = this.emitted;
                long r = this.requested.get();
                if (e != r) {
                    this.downstream.onNext(item);
                    this.emitted = e + 1L;
                    inner.producedOne();
                } else {
                    SimpleQueue<R> q = inner.queue();
                    q.offer(item);
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue<R> q = inner.queue();
                q.offer(item);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void innerError(FlatMapInnerSubscriber<T, R> inner, Throwable ex) {
            this.remove(inner);
            if (this.error.tryAddThrowableOrReport(ex)) {
                inner.done = true;
                this.done = true;
                this.upstream.cancel();
                this.cancelInners();
                this.drain();
            }
        }

        @Override
        public void innerComplete(FlatMapInnerSubscriber<T, R> inner) {
            inner.done = true;
            this.drain();
        }
    }

    static abstract class BaseFlatMapOuterSubscriber<T, R>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription,
    FlatMapInnerSubscriberSupport<T, R> {
        private static final long serialVersionUID = -208456984819517117L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int maxConcurrency;
        final int bufferSize;
        final AtomicLong requested;
        final AtomicReferenceArray<FlatMapInnerSubscriber<T, R>> subscribers;
        final AtomicIntegerArray freelist;
        final AtomicThrowable error;
        final boolean depthFirst;
        final AtomicLong active;
        volatile boolean done;
        volatile boolean cancelled;
        Subscription upstream;
        long emitted;
        long finished;
        static final int PRODUCER_INDEX = 16;
        static final int CONSUMER_INDEX = 32;

        BaseFlatMapOuterSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int bufferSize, boolean depthFirst) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.maxConcurrency = maxConcurrency;
            this.bufferSize = bufferSize;
            this.requested = new AtomicLong();
            this.error = new AtomicThrowable();
            this.depthFirst = depthFirst;
            this.active = new AtomicLong();
            int c = Pow2.roundToPowerOfTwo((int)maxConcurrency);
            this.subscribers = new AtomicReferenceArray(c);
            this.freelist = new AtomicIntegerArray(c + 32 + 16);
        }

        public final void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request((long)this.maxConcurrency);
            }
        }

        public final void onNext(T t) {
            Publisher p;
            try {
                p = (Publisher)Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.upstream.cancel();
                this.cancelInners();
                if (this.error.tryAddThrowableOrReport(ex)) {
                    this.done = true;
                    this.drain();
                }
                return;
            }
            if (!this.cancelled) {
                AtomicIntegerArray fl = this.freelist;
                AtomicReferenceArray<FlatMapInnerSubscriber<T, R>> s = this.subscribers;
                int m = s.length();
                int ci = fl.get(m + 32);
                int idx = fl.get(ci);
                if (idx == 0) {
                    idx = ci + 1;
                }
                FlatMapInnerSubscriber inner = new FlatMapInnerSubscriber(this, this.bufferSize, idx);
                s.lazySet(idx - 1, inner);
                fl.lazySet(m + 32, ci + 1 & m - 1);
                AtomicLong act = this.active;
                act.lazySet(act.get() + 1L);
                if (this.cancelled) {
                    s.lazySet(idx - 1, null);
                } else {
                    p.subscribe(inner);
                }
            }
        }

        public final void onError(Throwable t) {
            if (this.error.tryAddThrowableOrReport(t)) {
                this.done = true;
                this.drain();
            }
        }

        public final void onComplete() {
            this.done = true;
            this.drain();
        }

        public final void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public final void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                this.error.tryTerminateAndReport();
                this.cancelInners();
                this.cleanupAfter();
            }
        }

        abstract void cleanupAfter();

        final void depthFirst() {
            int missed = 1;
            long e = this.emitted;
            AtomicReferenceArray<FlatMapInnerSubscriber<T, R>> s = this.subscribers;
            int m = s.length();
            Subscriber<? super R> a = this.downstream;
            AtomicLong act = this.active;
            while (true) {
                int w;
                boolean d;
                long r = this.requested.get();
                while (e != r) {
                    Throwable ex;
                    if (this.cancelled) {
                        return;
                    }
                    d = this.done;
                    if (d && (ex = (Throwable)this.error.get()) != null) {
                        a.onError(this.error.terminate());
                        this.cleanupAfter();
                        return;
                    }
                    long n = act.get();
                    long f = this.finished;
                    int innerEmpty = 0;
                    int j = 0;
                    block4: for (int i = 0; i < m && (long)j + f < n; ++i) {
                        FlatMapInnerSubscriber<T, R> inner = s.get(i);
                        if (inner == null) continue;
                        ++j;
                        boolean innerDone = inner.done;
                        SimpleQueue q = inner.queue;
                        if (innerDone && (q == null || q.isEmpty())) {
                            this.remove(inner);
                            ++this.finished;
                            ++innerEmpty;
                            this.upstream.request(1L);
                            continue;
                        }
                        if (q != null) {
                            while (e != r) {
                                boolean empty;
                                Object v;
                                Throwable ex2;
                                if (this.cancelled) {
                                    return;
                                }
                                if (d && (ex2 = (Throwable)this.error.get()) != null) {
                                    this.error.tryTerminateConsumer(a);
                                    this.cleanupAfter();
                                    return;
                                }
                                try {
                                    v = q.poll();
                                }
                                catch (Throwable ex3) {
                                    Exceptions.throwIfFatal((Throwable)ex3);
                                    this.error.tryAddThrowableOrReport(ex3);
                                    this.upstream.cancel();
                                    this.cancelInners();
                                    this.error.tryTerminateConsumer(a);
                                    this.cleanupAfter();
                                    return;
                                }
                                boolean bl = empty = v == null;
                                if (innerDone && empty) {
                                    this.remove(inner);
                                    ++this.finished;
                                    ++innerEmpty;
                                    this.upstream.request(1L);
                                    continue block4;
                                }
                                if (empty) {
                                    ++innerEmpty;
                                    continue block4;
                                }
                                a.onNext(v);
                                ++e;
                                inner.producedOne();
                            }
                            continue;
                        }
                        ++innerEmpty;
                    }
                    n = act.get();
                    f = this.finished;
                    if (d && n == f) {
                        a.onComplete();
                        this.cleanupAfter();
                        return;
                    }
                    if ((long)innerEmpty + f != n) continue;
                    break;
                }
                if (e == r) {
                    if (this.cancelled) {
                        return;
                    }
                    d = this.done;
                    if (d) {
                        Throwable ex = (Throwable)this.error.get();
                        if (ex != null) {
                            this.error.tryTerminateConsumer(a);
                            this.cleanupAfter();
                            return;
                        }
                        long n = act.get();
                        if (n == this.finished) {
                            a.onComplete();
                            this.cleanupAfter();
                            return;
                        }
                    }
                }
                if ((w = this.get()) == missed) {
                    this.emitted = e;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        final void breadthFirst() {
            int missed = 1;
            long e = this.emitted;
            AtomicReferenceArray<FlatMapInnerSubscriber<T, R>> s = this.subscribers;
            int m = s.length();
            Subscriber<? super R> a = this.downstream;
            AtomicLong act = this.active;
            while (true) {
                int w;
                long r = this.requested.get();
                long alive = act.get() - this.finished;
                int innerEmpty = 0;
                int j = 0;
                for (int i = 0; i < m && (long)j < alive; ++i) {
                    Throwable ex;
                    if (this.cancelled) {
                        return;
                    }
                    if (this.done && (ex = (Throwable)this.error.get()) != null) {
                        this.error.tryTerminateConsumer(a);
                        this.cleanupAfter();
                        return;
                    }
                    FlatMapInnerSubscriber<T, R> inner = s.get(i);
                    if (inner == null) continue;
                    ++j;
                    boolean innerDone = inner.done;
                    SimpleQueue q = inner.queue;
                    if (innerDone && (q == null || q.isEmpty())) {
                        this.remove(inner);
                        ++this.finished;
                        ++innerEmpty;
                        this.upstream.request(1L);
                        continue;
                    }
                    if (q != null) {
                        Object v;
                        if (e == r) continue;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex2) {
                            Exceptions.throwIfFatal((Throwable)ex2);
                            this.error.tryAddThrowableOrReport(ex2);
                            this.upstream.cancel();
                            this.cancelInners();
                            this.error.tryTerminateConsumer(a);
                            this.cleanupAfter();
                            return;
                        }
                        if (v == null) {
                            ++innerEmpty;
                            continue;
                        }
                        a.onNext(v);
                        ++e;
                        inner.producedOne();
                        continue;
                    }
                    ++innerEmpty;
                }
                if (e == r) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.done) {
                        Throwable ex = (Throwable)this.error.get();
                        if (ex != null) {
                            this.error.tryTerminateConsumer(a);
                            this.cleanupAfter();
                            return;
                        }
                        if (this.finished == act.get()) {
                            a.onComplete();
                            this.cleanupAfter();
                            return;
                        }
                    }
                } else {
                    long f = this.finished;
                    long in2 = act.get();
                    if (this.done && in2 == f) {
                        a.onComplete();
                        this.cleanupAfter();
                        return;
                    }
                    if ((long)innerEmpty != alive) continue;
                }
                if ((w = this.get()) == missed) {
                    this.emitted = e;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        final void remove(FlatMapInnerSubscriber<T, R> inner) {
            AtomicIntegerArray fl = this.freelist;
            AtomicReferenceArray<FlatMapInnerSubscriber<T, R>> s = this.subscribers;
            int m = s.length();
            int idx = inner.index;
            int pi = fl.get(m + 16);
            s.lazySet(idx - 1, null);
            fl.lazySet(pi, idx);
            fl.lazySet(m + 16, pi + 1 & m - 1);
        }

        final void cancelInners() {
            AtomicReferenceArray<FlatMapInnerSubscriber<T, R>> s = this.subscribers;
            int m = s.length();
            for (int i = 0; i < m; ++i) {
                FlatMapInnerSubscriber<T, R> inner = s.get(i);
                if (inner == null) continue;
                s.lazySet(i, null);
                inner.cancel();
            }
        }
    }

    static interface FlatMapInnerSubscriberSupport<T, R> {
        public void innerNext(FlatMapInnerSubscriber<T, R> var1, R var2);

        public void innerError(FlatMapInnerSubscriber<T, R> var1, Throwable var2);

        public void innerComplete(FlatMapInnerSubscriber<T, R> var1);

        public void drain();
    }
}

