/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.internal.fuseable.ConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;

final class FlowableRepeatScalar<T>
extends Flowable<T> {
    final T value;

    FlowableRepeatScalar(T value) {
        this.value = value;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        if (s instanceof ConditionalSubscriber) {
            s.onSubscribe(new RepeatScalarConditionalSubscription<T>((ConditionalSubscriber)s, this.value));
        } else {
            s.onSubscribe(new RepeatScalarSubscription<T>(s, this.value));
        }
    }

    static final class RepeatScalarConditionalSubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -231033913007168200L;
        final ConditionalSubscriber<? super T> downstream;
        T value;
        volatile boolean cancelled;

        RepeatScalarConditionalSubscription(ConditionalSubscriber<? super T> downstream, T value) {
            this.downstream = downstream;
            this.value = value;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n) && BackpressureHelper.add((AtomicLong)((Object)this), (long)n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastpath();
                } else {
                    this.slowpath(n);
                }
            }
        }

        void fastpath() {
            T v = this.value;
            while (!this.cancelled) {
                this.downstream.tryOnNext(v);
            }
        }

        void slowpath(long r) {
            T v = this.value;
            long e = 0L;
            while (true) {
                if (e != r) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.downstream.tryOnNext(v)) continue;
                    ++e;
                    continue;
                }
                if (this.cancelled) {
                    return;
                }
                r = this.get();
                if (e != r) continue;
                r = this.addAndGet(-e);
                if (r == 0L) break;
                e = 0L;
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        public int requestFusion(int mode) {
            return mode & 1;
        }

        public T poll() throws Exception {
            return this.value;
        }

        public boolean isEmpty() {
            return this.value == null;
        }

        public void clear() {
            this.value = null;
        }
    }

    static final class RepeatScalarSubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -231033913007168200L;
        final Subscriber<? super T> downstream;
        T value;
        volatile boolean cancelled;

        RepeatScalarSubscription(Subscriber<? super T> downstream, T value) {
            this.downstream = downstream;
            this.value = value;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n) && BackpressureHelper.add((AtomicLong)((Object)this), (long)n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastpath();
                } else {
                    this.slowpath(n);
                }
            }
        }

        void fastpath() {
            T v = this.value;
            while (!this.cancelled) {
                this.downstream.onNext(v);
            }
        }

        void slowpath(long r) {
            T v = this.value;
            long e = 0L;
            while (true) {
                if (e != r) {
                    if (this.cancelled) {
                        return;
                    }
                    this.downstream.onNext(v);
                    ++e;
                    continue;
                }
                if (this.cancelled) {
                    return;
                }
                r = this.get();
                if (e != r) continue;
                r = this.addAndGet(-e);
                if (r == 0L) break;
                e = 0L;
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        public int requestFusion(int mode) {
            return mode & 1;
        }

        public T poll() throws Exception {
            return this.value;
        }

        public boolean isEmpty() {
            return this.value == null;
        }

        public void clear() {
            this.value = null;
        }
    }
}

