/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableRequestSampleTime<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Flowable<T> source;
    final long initialDelay;
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;

    FlowableRequestSampleTime(Flowable<T> source, long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableRequestSampleTime<T>(upstream, this.initialDelay, this.period, this.unit, this.scheduler);
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        RequestSample<? super T> parent = new RequestSample<T>(s);
        s.onSubscribe(parent);
        DisposableHelper.setOnce(parent.timer, (Disposable)this.scheduler.schedulePeriodicallyDirect(parent, this.initialDelay, this.period, this.unit));
        this.source.subscribe(parent);
    }

    static final class RequestSample<T>
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        final Subscriber<? super T> downstream;
        final AtomicLong downstreamRequests;
        final AtomicLong upstreamRequests;
        final AtomicReference<Subscription> upstream;
        final AtomicReference<Disposable> timer;
        long emitted;
        boolean done;

        RequestSample(Subscriber<? super T> downstream) {
            this.downstream = downstream;
            this.downstreamRequests = new AtomicLong();
            this.upstreamRequests = new AtomicLong();
            this.upstream = new AtomicReference();
            this.timer = new AtomicReference();
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce(this.upstream, (AtomicLong)this.upstreamRequests, (Subscription)s);
        }

        public void onNext(T t) {
            if (!this.done) {
                long e = this.emitted;
                if (this.downstreamRequests.get() != e) {
                    this.emitted = e + 1L;
                    this.downstream.onNext(t);
                } else {
                    this.done = true;
                    this.cancel();
                    this.downstream.onError((Throwable)new MissingBackpressureException("Downstream is not ready to receive the next upstream item."));
                }
            }
        }

        public void onError(Throwable t) {
            if (!this.done) {
                this.done = true;
                this.downstream.onError(t);
                DisposableHelper.dispose(this.timer);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
                DisposableHelper.dispose(this.timer);
            }
        }

        @Override
        public void run() {
            SubscriptionHelper.deferredRequest(this.upstream, (AtomicLong)this.upstreamRequests, (long)1L);
        }

        public void request(long n) {
            BackpressureHelper.add((AtomicLong)this.downstreamRequests, (long)n);
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            DisposableHelper.dispose(this.timer);
        }
    }
}

