/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.fuseable.SimplePlainQueue;
import io.reactivex.rxjava3.internal.queue.SpscArrayQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableSwitchFlatMap<T, R>
extends Flowable<R>
implements FlowableTransformer<T, R> {
    final Publisher<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int maxActive;
    final int bufferSize;

    FlowableSwitchFlatMap(Publisher<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxActive, int bufferSize) {
        this.source = source;
        this.mapper = mapper;
        this.maxActive = maxActive;
        this.bufferSize = bufferSize;
    }

    public Publisher<R> apply(Flowable<T> upstream) {
        return new FlowableSwitchFlatMap<T, R>(upstream, this.mapper, this.maxActive, this.bufferSize);
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new SwitchFlatMapSubscriber<T, R>(s, this.mapper, this.maxActive, this.bufferSize));
    }

    static final class SwitchFlatMapSubscriber<T, R>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = 6801374887555723721L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int maxActive;
        final int bufferSize;
        final ArrayDeque<SfmInnerSubscriber<T, R>> active;
        final AtomicLong requested;
        final AtomicThrowable error;
        Subscription upstream;
        volatile boolean done;
        volatile boolean cancelled;
        volatile long version;
        final SfmInnerSubscriber<T, R>[] activeCache;
        long versionCache;

        SwitchFlatMapSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxActive, int bufferSize) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.maxActive = maxActive;
            this.bufferSize = bufferSize;
            this.active = new ArrayDeque();
            this.requested = new AtomicLong();
            this.error = new AtomicThrowable();
            this.activeCache = new SfmInnerSubscriber[maxActive];
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Publisher p;
            try {
                p = (Publisher)Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            SfmInnerSubscriber inner = new SfmInnerSubscriber(this, this.bufferSize);
            if (this.add(inner)) {
                p.subscribe(inner);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(SfmInnerSubscriber<T, R> inner) {
            SfmInnerSubscriber<T, R> evicted = null;
            SwitchFlatMapSubscriber switchFlatMapSubscriber = this;
            synchronized (switchFlatMapSubscriber) {
                if (this.cancelled) {
                    return false;
                }
                if (this.active.size() == this.maxActive) {
                    evicted = this.active.poll();
                }
                this.active.offer(inner);
                ++this.version;
            }
            if (evicted != null) {
                evicted.cancel();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(SfmInnerSubscriber<T, R> inner) {
            SwitchFlatMapSubscriber switchFlatMapSubscriber = this;
            synchronized (switchFlatMapSubscriber) {
                this.active.remove(inner);
                ++this.version;
            }
        }

        public void onError(Throwable t) {
            if (this.error.compareAndSet(null, (Object)t)) {
                this.cancelInners();
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                this.cancelInners();
                if (this.getAndIncrement() == 0) {
                    this.clearCache();
                }
            }
        }

        void clearCache() {
            Arrays.fill(this.activeCache, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelInners() {
            ArrayList<SfmInnerSubscriber<T, R>> subscribers = new ArrayList<SfmInnerSubscriber<T, R>>();
            SwitchFlatMapSubscriber switchFlatMapSubscriber = this;
            synchronized (switchFlatMapSubscriber) {
                subscribers.addAll(this.active);
                this.active.clear();
            }
            for (SfmInnerSubscriber sfmInnerSubscriber : subscribers) {
                sfmInnerSubscriber.cancel();
            }
        }

        void innerError(Throwable t) {
            if (this.error.compareAndSet(null, (Object)t)) {
                this.upstream.cancel();
                this.cancelInners();
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateInners() {
            SfmInnerSubscriber<T, R>[] a = this.activeCache;
            if (this.versionCache != this.version) {
                SwitchFlatMapSubscriber switchFlatMapSubscriber = this;
                synchronized (switchFlatMapSubscriber) {
                    int i = 0;
                    Iterator<SfmInnerSubscriber<T, R>> it = this.active.iterator();
                    while (it.hasNext()) {
                        a[i++] = it.next();
                    }
                    for (int j = i; j < a.length; ++j) {
                        a[j] = null;
                    }
                    this.versionCache = this.version;
                }
            }
        }

        void drain() {
            block19: {
                if (this.getAndIncrement() != 0) break block19;
                int missed = 1;
                Subscriber<? super R> a = this.downstream;
                SfmInnerSubscriber<T, R>[] inners = this.activeCache;
                AtomicThrowable err = this.error;
                block0: while (true) {
                    int activeCount;
                    int becameEmpty;
                    long r = this.requested.get();
                    long e = 0L;
                    block1: do {
                        if (this.cancelled) {
                            this.clearCache();
                            return;
                        }
                        boolean d = this.done;
                        this.updateInners();
                        long ver = this.versionCache;
                        if (d) {
                            Throwable ex = (Throwable)err.get();
                            if (ex != null) {
                                this.clearCache();
                                a.onError(err.terminate());
                                return;
                            }
                            if (inners[0] == null) {
                                a.onComplete();
                                return;
                            }
                        }
                        becameEmpty = 0;
                        activeCount = 0;
                        block2: for (SfmInnerSubscriber<T, R> inner : inners) {
                            if (this.cancelled) {
                                this.clearCache();
                                return;
                            }
                            if (inner == null) continue block1;
                            if (ver != this.version) {
                                if (e == 0L) continue block0;
                                BackpressureHelper.produced((AtomicLong)this.requested, (long)e);
                                continue block0;
                            }
                            ++activeCount;
                            long f = 0L;
                            SimplePlainQueue q = inner.queue;
                            while (e != r) {
                                boolean empty;
                                if (this.cancelled) {
                                    this.clearCache();
                                    return;
                                }
                                Throwable ex = (Throwable)err.get();
                                if (ex != null) {
                                    this.clearCache();
                                    a.onError(err.terminate());
                                    return;
                                }
                                if (ver != this.version) {
                                    if (e != 0L) {
                                        BackpressureHelper.produced((AtomicLong)this.requested, (long)e);
                                    }
                                    if (f == 0L) continue block0;
                                    inner.produced(f);
                                    continue block0;
                                }
                                boolean d2 = inner.done;
                                Object v = q.poll();
                                boolean bl = empty = v == null;
                                if (d2 && empty) {
                                    this.remove(inner);
                                    continue block2;
                                }
                                if (empty) {
                                    if (f != 0L) {
                                        inner.produced(f);
                                        f = 0L;
                                    }
                                    ++becameEmpty;
                                    break;
                                }
                                a.onNext(v);
                                ++e;
                                ++f;
                            }
                            if (inner.done && q.isEmpty()) {
                                this.remove(inner);
                                continue;
                            }
                            if (f == 0L) continue;
                            inner.produced(f);
                        }
                    } while (becameEmpty != activeCount && e != r);
                    if (e != 0L) {
                        BackpressureHelper.produced((AtomicLong)this.requested, (long)e);
                    }
                    if ((missed = this.addAndGet(-missed)) == 0) break;
                }
            }
        }

        static final class SfmInnerSubscriber<T, R>
        extends AtomicReference<Subscription>
        implements Subscriber<R> {
            private static final long serialVersionUID = 4011255448052082638L;
            final SwitchFlatMapSubscriber<T, R> parent;
            final int bufferSize;
            final int limit;
            final SimplePlainQueue<R> queue;
            long produced;
            volatile boolean done;

            SfmInnerSubscriber(SwitchFlatMapSubscriber<T, R> parent, int bufferSize) {
                this.parent = parent;
                this.bufferSize = bufferSize;
                this.limit = bufferSize - (bufferSize >> 2);
                this.queue = new SpscArrayQueue(bufferSize);
            }

            void cancel() {
                SubscriptionHelper.cancel((AtomicReference)this);
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request((long)this.bufferSize);
                }
            }

            public void onNext(R t) {
                this.queue.offer(t);
                this.parent.drain();
            }

            public void onError(Throwable t) {
                this.parent.innerError(t);
            }

            public void onComplete() {
                this.done = true;
                this.parent.drain();
            }

            void produced(long f) {
                long p = this.produced + f;
                if (p >= (long)this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
            }
        }
    }
}

