/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableSwitchIfEmptyMany<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Flowable<T> source;
    final Iterable<? extends Publisher<? extends T>> alternatives;

    FlowableSwitchIfEmptyMany(Flowable<T> source, Iterable<? extends Publisher<? extends T>> alternatives) {
        this.source = source;
        this.alternatives = alternatives;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        Iterator<? extends Publisher<? extends T>> it;
        try {
            it = this.alternatives.iterator();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        SwitchManySubscriber<T> parent = new SwitchManySubscriber<T>(s, it);
        s.onSubscribe(parent);
        parent.drain((Publisher<T>)this.source);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableSwitchIfEmptyMany<T>(upstream, this.alternatives);
    }

    static final class SwitchManySubscriber<T>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -174718617614474267L;
        final Subscriber<? super T> downstream;
        final AtomicLong requested;
        final AtomicReference<Subscription> upstream;
        final Iterator<? extends Publisher<? extends T>> alternatives;
        boolean hasValue;
        volatile boolean active;

        SwitchManySubscriber(Subscriber<? super T> downstream, Iterator<? extends Publisher<? extends T>> alternatives) {
            this.downstream = downstream;
            this.alternatives = alternatives;
            this.requested = new AtomicLong();
            this.upstream = new AtomicReference();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                Subscription a = this.upstream.get();
                if (a != null) {
                    a.request(n);
                }
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
        }

        public void onSubscribe(Subscription s) {
            long n;
            if (SubscriptionHelper.replace(this.upstream, (Subscription)s) && (n = this.requested.get()) != 0L) {
                s.request(n);
            }
        }

        public void onNext(T t) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.downstream.onNext(t);
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void onComplete() {
            if (this.hasValue) {
                this.downstream.onComplete();
            } else {
                this.active = false;
                this.drain(null);
            }
        }

        void drain(Publisher<? extends T> source) {
            if (this.getAndIncrement() == 0) {
                do {
                    if (SubscriptionHelper.CANCELLED == this.upstream.get()) {
                        return;
                    }
                    if (this.active) continue;
                    if (source == null) {
                        boolean b;
                        try {
                            b = this.alternatives.hasNext();
                            if (b) {
                                source = this.alternatives.next();
                            }
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            this.downstream.onError(ex);
                            return;
                        }
                        if (!b) {
                            this.downstream.onComplete();
                            return;
                        }
                        if (source == null) {
                            this.downstream.onError((Throwable)new NullPointerException("The alternative Publisher is null"));
                            return;
                        }
                    }
                    this.active = true;
                    source.subscribe((Subscriber)this);
                    source = null;
                } while (this.decrementAndGet() != 0);
            }
        }
    }
}

