/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.fuseable.ConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableWindowPredicate<T>
extends Flowable<Flowable<T>>
implements FlowableTransformer<T, Flowable<T>> {
    final Publisher<T> source;
    final Predicate<? super T> predicate;
    final Mode mode;
    final int bufferSize;

    FlowableWindowPredicate(Publisher<T> source, Predicate<? super T> predicate, Mode mode, int bufferSize) {
        this.source = source;
        this.predicate = predicate;
        this.mode = mode;
        this.bufferSize = bufferSize;
    }

    protected void subscribeActual(Subscriber<? super Flowable<T>> s) {
        this.source.subscribe(new WindowPredicateSubscriber<T>(s, this.predicate, this.mode, this.bufferSize));
    }

    public Publisher<Flowable<T>> apply(Flowable<T> upstream) {
        return new FlowableWindowPredicate<T>(upstream, this.predicate, this.mode, this.bufferSize);
    }

    static final class WindowPredicateSubscriber<T>
    extends AtomicInteger
    implements ConditionalSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 2749959965593866309L;
        final Subscriber<? super Flowable<T>> downstream;
        final Predicate<? super T> predicate;
        final Mode mode;
        final int bufferSize;
        final AtomicBoolean cancelled = new AtomicBoolean();
        Subscription upstream;
        UnicastProcessor<T> window;
        final AtomicLong requestedWindows;
        final AtomicReference<UnicastProcessor<T>> pending;

        WindowPredicateSubscriber(Subscriber<? super Flowable<T>> downstream, Predicate<? super T> predicate, Mode mode, int bufferSize) {
            super(1);
            this.downstream = downstream;
            this.predicate = predicate;
            this.mode = mode;
            this.bufferSize = bufferSize;
            if (mode == Mode.BEFORE) {
                this.requestedWindows = new AtomicLong();
                this.pending = new AtomicReference();
            } else {
                this.requestedWindows = null;
                this.pending = null;
            }
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            boolean b;
            UnicastProcessor w = this.window;
            if (w == null) {
                if (this.cancelled.get()) {
                    return true;
                }
                this.window = w = UnicastProcessor.create((int)this.bufferSize, (Runnable)this);
                this.getAndIncrement();
                if (this.mode == Mode.BEFORE) {
                    this.requestedWindows.getAndDecrement();
                }
                this.downstream.onNext((Object)w);
            }
            try {
                b = this.predicate.test(t) ^ this.mode == Mode.BEFORE;
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.upstream.cancel();
                this.downstream.onError(ex);
                w.onError(ex);
                this.window = null;
                return true;
            }
            if (b) {
                if (this.mode == Mode.AFTER) {
                    w.onNext(t);
                }
                w.onComplete();
                if (this.mode == Mode.BEFORE) {
                    this.window = w = UnicastProcessor.create((int)this.bufferSize, (Runnable)this);
                    w.onNext(t);
                    this.pending.set(w);
                    this.drain();
                } else {
                    this.window = null;
                }
            } else {
                w.onNext(t);
            }
            return b;
        }

        public void onError(Throwable t) {
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.downstream.onError(t);
        }

        public void onComplete() {
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.downstream.onComplete();
        }

        public void request(long n) {
            if (this.mode == Mode.BEFORE && SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requestedWindows, (long)n);
                this.drain();
            }
            this.upstream.request(n);
        }

        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }

        private void drain() {
            if (this.requestedWindows.get() <= 0L) {
                return;
            }
            UnicastProcessor w = this.pending.getAndSet(null);
            if (w == null) {
                return;
            }
            this.getAndIncrement();
            this.requestedWindows.getAndDecrement();
            this.downstream.onNext((Object)w);
        }
    }

    static enum Mode {
        BEFORE,
        AFTER,
        SPLIT;

    }
}

