/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import hu.akarnokd.rxjava3.operators.FlowableAsyncEmitter;
import hu.akarnokd.rxjava3.operators.FlowableGenerateAsync;
import hu.akarnokd.rxjava3.operators.FlowableIntervalBackpressure;
import hu.akarnokd.rxjava3.operators.FlowableOrderedMerge;
import hu.akarnokd.rxjava3.operators.FlowableRepeatScalar;
import hu.akarnokd.rxjava3.operators.FlowableRepeatSupplier;
import hu.akarnokd.rxjava3.operators.FlowableZipLatest;
import io.reactivex.rxjava3.annotations.BackpressureKind;
import io.reactivex.rxjava3.annotations.BackpressureSupport;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.SchedulerSupport;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Function3;
import io.reactivex.rxjava3.functions.Function4;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.schedulers.ImmediateThinScheduler;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public final class Flowables {
    private Flowables() {
        throw new IllegalStateException("No instances!");
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(Publisher<T> ... sources) {
        return Flowables.orderedMerge(Comparator.naturalOrder(), false, Flowable.bufferSize(), sources);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(boolean delayErrors, Publisher<T> ... sources) {
        return Flowables.orderedMerge(Comparator.naturalOrder(), delayErrors, Flowable.bufferSize(), sources);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(boolean delayErrors, int prefetch, Publisher<T> ... sources) {
        return Flowables.orderedMerge(Comparator.naturalOrder(), delayErrors, prefetch, sources);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    public static <T> Flowable<T> orderedMerge(Comparator<? super T> comparator, Publisher<T> ... sources) {
        return Flowables.orderedMerge(comparator, false, Flowable.bufferSize(), sources);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    public static <T> Flowable<T> orderedMerge(Comparator<? super T> comparator, boolean delayErrors, Publisher<T> ... sources) {
        return Flowables.orderedMerge(comparator, delayErrors, Flowable.bufferSize(), sources);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    public static <T> Flowable<T> orderedMerge(Comparator<? super T> comparator, boolean delayErrors, int prefetch, Publisher<T> ... sources) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaPlugins.onAssembly(new FlowableOrderedMerge<T>(sources, null, comparator, delayErrors, prefetch));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources, Comparator<? super T> comparator) {
        return Flowables.orderedMerge(sources, comparator, false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources, Comparator<? super T> comparator, boolean delayErrors) {
        return Flowables.orderedMerge(sources, comparator, delayErrors, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources, Comparator<? super T> comparator, boolean delayErrors, int prefetch) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaPlugins.onAssembly(new FlowableOrderedMerge<T>(null, sources, comparator, delayErrors, prefetch));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources) {
        return Flowables.orderedMerge(sources, Comparator.naturalOrder(), false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources, boolean delayErrors) {
        return Flowables.orderedMerge(sources, Comparator.naturalOrder(), delayErrors, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(Iterable<? extends Publisher<T>> sources, boolean delayErrors, int prefetch) {
        return Flowables.orderedMerge(sources, Comparator.naturalOrder(), delayErrors, prefetch);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> repeat(T item) {
        Objects.requireNonNull(item, "item is null");
        return RxJavaPlugins.onAssembly(new FlowableRepeatScalar<T>(item));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> repeatSupplier(Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new FlowableRepeatSupplier<T>(supplier));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> intervalBackpressure(long period, TimeUnit unit) {
        return Flowables.intervalBackpressure(period, period, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> intervalBackpressure(long period, TimeUnit unit, Scheduler scheduler) {
        return Flowables.intervalBackpressure(period, period, unit, scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> intervalBackpressure(long initialDelay, long period, TimeUnit unit) {
        return Flowables.intervalBackpressure(initialDelay, period, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> intervalBackpressure(long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        return RxJavaPlugins.onAssembly((Flowable)new FlowableIntervalBackpressure(initialDelay, period, unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    @SafeVarargs
    public static <T, R> Flowable<R> zipLatest(Function<? super Object[], ? extends R> combiner, Publisher<? extends T> ... sources) {
        return Flowables.zipLatest(combiner, ImmediateThinScheduler.INSTANCE, sources);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    @SafeVarargs
    public static <T, R> Flowable<R> zipLatest(Function<? super Object[], ? extends R> combiner, Scheduler scheduler, Publisher<? extends T> ... sources) {
        Objects.requireNonNull(combiner, "combiner is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableZipLatest<T, R>(sources, null, combiner, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public static <T, R> Flowable<R> zipLatest(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> combiner) {
        return Flowables.zipLatest(sources, combiner, ImmediateThinScheduler.INSTANCE);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public static <T, R> Flowable<R> zipLatest(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> combiner, Scheduler scheduler) {
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(combiner, "combiner is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableZipLatest(null, sources, combiner, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public static <T1, T2, R> Flowable<R> zipLatest(Publisher<T1> source1, Publisher<T2> source2, BiFunction<? super T1, ? super T2, ? extends R> combiner) {
        return Flowables.zipLatest(source1, source2, combiner, ImmediateThinScheduler.INSTANCE);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public static <T1, T2, R> Flowable<R> zipLatest(Publisher<T1> source1, Publisher<T2> source2, BiFunction<? super T1, ? super T2, ? extends R> combiner, Scheduler scheduler) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableZipLatest(new Publisher[]{source1, source2}, null, Functions.toFunction(combiner), scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, R> Flowable<R> zipLatest(Publisher<T1> source1, Publisher<T2> source2, Publisher<T3> source3, Function3<? super T1, ? super T2, ? super T3, ? extends R> combiner) {
        return Flowables.zipLatest(source1, source2, source3, combiner, ImmediateThinScheduler.INSTANCE);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public static <T1, T2, T3, R> Flowable<R> zipLatest(Publisher<T1> source1, Publisher<T2> source2, Publisher<T3> source3, Function3<? super T1, ? super T2, ? super T3, ? extends R> combiner, Scheduler scheduler) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableZipLatest(new Publisher[]{source1, source2, source3}, null, Functions.toFunction(combiner), scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, R> Flowable<R> zipLatest(Publisher<T1> source1, Publisher<T2> source2, Publisher<T3> source3, Publisher<T4> source4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combiner) {
        return Flowables.zipLatest(source1, source2, source3, source4, combiner, ImmediateThinScheduler.INSTANCE);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public static <T1, T2, T3, T4, R> Flowable<R> zipLatest(Publisher<T1> source1, Publisher<T2> source2, Publisher<T3> source3, Publisher<T4> source4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combiner, Scheduler scheduler) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableZipLatest(new Publisher[]{source1, source2, source3, source4}, null, Functions.toFunction(combiner), scheduler));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, S> Flowable<T> generateAsync(Supplier<S> initialState, BiFunction<S, FlowableAsyncEmitter<T>, S> asyncGenerator, Consumer<? super S> stateCleanup) {
        Objects.requireNonNull(initialState, "initialState is null");
        Objects.requireNonNull(asyncGenerator, "asyncGenerator is null");
        Objects.requireNonNull(stateCleanup, "stateCleanup is null");
        return RxJavaPlugins.onAssembly(new FlowableGenerateAsync<T, S>(initialState, asyncGenerator, stateCleanup));
    }
}

