/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableFlatMapLatest<T, R>
extends Observable<R>
implements ObservableTransformer<T, R> {
    final Observable<T> source;
    final Function<? super T, ? extends ObservableSource<? extends R>> mapper;

    ObservableFlatMapLatest(Observable<T> source, Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    public ObservableSource<R> apply(Observable<T> upstream) {
        return new ObservableFlatMapLatest<T, R>(upstream, this.mapper);
    }

    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new FlatMapLatestObserver<T, R>(observer, this.mapper));
    }

    static final class FlatMapLatestObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 1251911925259779985L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
        final FlatMapLatestInnerObserver innerObserver;
        final AtomicThrowable errors;
        final AtomicReference<T> latest;
        Disposable upstream;
        volatile boolean active;
        volatile boolean done;
        volatile boolean disposed;

        FlatMapLatestObserver(Observer<? super R> downstream, Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.innerObserver = new FlatMapLatestInnerObserver();
            this.errors = new AtomicThrowable();
            this.latest = new AtomicReference();
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)this.upstream, (Disposable)d)) {
                this.upstream = d;
                this.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onNext(T t) {
            this.latest.set(t);
            this.drain();
        }

        public void onError(Throwable e) {
            if (this.errors.tryAddThrowableOrReport(e)) {
                this.onComplete();
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
            DisposableHelper.dispose((AtomicReference)this.innerObserver);
            this.errors.tryTerminateAndReport();
            if (this.getAndIncrement() == 0) {
                this.latest.lazySet(null);
            }
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        void innerNext(R item) {
            this.downstream.onNext(item);
        }

        void innerError(Throwable e) {
            if (this.errors.tryAddThrowableOrReport(e)) {
                this.innerComplete();
            }
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                ObservableSource o;
                if (this.disposed) {
                    this.latest.lazySet(null);
                    return;
                }
                if (this.active) continue;
                boolean d = this.done;
                Object v = this.latest.getAndSet(null);
                if (d && v == null) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (v == null) continue;
                try {
                    o = (ObservableSource)Objects.requireNonNull(this.mapper.apply(v), "The mapper returned a null ObservableSource");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.upstream.dispose();
                    this.errors.tryAddThrowableOrReport(ex);
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                this.active = true;
                o.subscribe((Observer)this.innerObserver);
            } while (this.decrementAndGet() != 0);
        }

        final class FlatMapLatestInnerObserver
        extends AtomicReference<Disposable>
        implements Observer<R> {
            private static final long serialVersionUID = -3707363807296094399L;

            FlatMapLatestInnerObserver() {
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.replace((AtomicReference)this, (Disposable)d);
            }

            public void onNext(R t) {
                FlatMapLatestObserver.this.innerNext(t);
            }

            public void onError(Throwable e) {
                FlatMapLatestObserver.this.innerError(e);
            }

            public void onComplete() {
                FlatMapLatestObserver.this.innerComplete();
            }
        }
    }
}

