/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableObserveOnDrop<T>
extends Observable<T>
implements ObservableTransformer<T, T> {
    final Observable<T> source;
    final Scheduler scheduler;

    ObservableObserveOnDrop(Observable<T> source, Scheduler scheduler) {
        this.source = source;
        this.scheduler = scheduler;
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return new ObservableObserveOnDrop<T>(upstream, this.scheduler);
    }

    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new ObserveOnDropObserver<T>(observer, this.scheduler.createWorker()));
    }

    static final class ObserveOnDropObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = -11696478502477044L;
        final Observer<? super T> downstream;
        final Scheduler.Worker worker;
        final AtomicReference<Object> item;
        static final Object WORKING = new Object();
        Disposable upstream;
        volatile boolean disposed;
        volatile boolean done;
        Throwable error;

        ObserveOnDropObserver(Observer<? super T> downstream, Scheduler.Worker worker) {
            this.downstream = downstream;
            this.worker = worker;
            this.item = new AtomicReference();
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)this.upstream, (Disposable)d)) {
                this.upstream = d;
                this.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onNext(T t) {
            if (this.item.compareAndSet(null, t)) {
                this.drain();
            }
        }

        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.item.lazySet(WORKING);
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule((Runnable)this);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            Observer<? super T> a = this.downstream;
            while (true) {
                boolean empty;
                if (this.disposed) {
                    this.item.lazySet(WORKING);
                    return;
                }
                boolean d = this.done;
                Object v = this.item.get();
                boolean bl = empty = v == null;
                if (d && empty) {
                    Throwable ex = this.error;
                    if (ex == null) {
                        a.onComplete();
                    } else {
                        a.onError(ex);
                    }
                    this.worker.dispose();
                    return;
                }
                if (!empty) {
                    v = this.item.getAndSet(WORKING);
                    a.onNext(v);
                    this.item.set(null);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

