/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import hu.akarnokd.rxjava3.operators.ObservableErrorJump;
import hu.akarnokd.rxjava3.operators.ObservableFilterAsync;
import hu.akarnokd.rxjava3.operators.ObservableFlatMapDrop;
import hu.akarnokd.rxjava3.operators.ObservableFlatMapLatest;
import hu.akarnokd.rxjava3.operators.ObservableIndexOf;
import hu.akarnokd.rxjava3.operators.ObservableMapAsync;
import hu.akarnokd.rxjava3.operators.ObservableObserveOnDrop;
import hu.akarnokd.rxjava3.operators.ObservableObserveOnLatest;
import hu.akarnokd.rxjava3.operators.ObservableValve;
import hu.akarnokd.rxjava3.util.BiFunctionSecondIdentity;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.SchedulerSupport;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import java.util.Objects;

public final class ObservableTransformers {
    private ObservableTransformers() {
        throw new IllegalStateException("No instances!");
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public static <T> ObservableTransformer<T, Long> indexOf(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return new ObservableIndexOf<T>(null, predicate);
    }

    @SchedulerSupport(value="custom")
    @CheckReturnValue
    @NonNull
    public static <T> ObservableTransformer<T, T> observeOnDrop(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ObservableObserveOnDrop(null, scheduler);
    }

    @SchedulerSupport(value="custom")
    @CheckReturnValue
    @NonNull
    public static <T> ObservableTransformer<T, T> observeOnLatest(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ObservableObserveOnLatest(null, scheduler);
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public static <T, R> ObservableTransformer<T, R> flatMapDrop(Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return new ObservableFlatMapDrop(null, mapper);
    }

    @SchedulerSupport(value="none")
    @CheckReturnValue
    @NonNull
    public static <T, R> ObservableTransformer<T, R> flatMapLatest(Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return new ObservableFlatMapLatest(null, mapper);
    }

    public static <T, R> ObservableTransformer<T, R> errorJump(ObservableTransformer<T, R> transformer) {
        Objects.requireNonNull(transformer, "transformer");
        return new ObservableErrorJump<T, R>(null, transformer);
    }

    @SchedulerSupport(value="none")
    public static <T> ObservableTransformer<T, T> valve(ObservableSource<Boolean> other) {
        return ObservableTransformers.valve(other, true, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T> ObservableTransformer<T, T> valve(ObservableSource<Boolean> other, boolean defaultOpen) {
        return ObservableTransformers.valve(other, defaultOpen, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public static <T> ObservableTransformer<T, T> valve(ObservableSource<Boolean> other, boolean defaultOpen, int bufferSize) {
        Objects.requireNonNull(other, "other is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return new ObservableValve(null, other, defaultOpen, bufferSize);
    }

    public static <T, R> ObservableTransformer<T, R> mapAsync(Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return ObservableTransformers.mapAsync(mapper, BiFunctionSecondIdentity.instance(), Flowable.bufferSize());
    }

    public static <T, R> ObservableTransformer<T, R> mapAsync(Function<? super T, ? extends ObservableSource<? extends R>> mapper, int capacityHint) {
        return ObservableTransformers.mapAsync(mapper, BiFunctionSecondIdentity.instance(), capacityHint);
    }

    public static <T, U, R> ObservableTransformer<T, R> mapAsync(Function<? super T, ? extends ObservableSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner) {
        return ObservableTransformers.mapAsync(mapper, combiner, Flowable.bufferSize());
    }

    public static <T, U, R> ObservableTransformer<T, R> mapAsync(Function<? super T, ? extends ObservableSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, int capacityHint) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive((int)capacityHint, (String)"capacityHint");
        return new ObservableMapAsync<T, U, R>(null, mapper, combiner, capacityHint);
    }

    public static <T> ObservableTransformer<T, T> filterAsync(Function<? super T, ? extends ObservableSource<Boolean>> asyncPredicate) {
        return ObservableTransformers.filterAsync(asyncPredicate, Flowable.bufferSize());
    }

    public static <T> ObservableTransformer<T, T> filterAsync(Function<? super T, ? extends ObservableSource<Boolean>> asyncPredicate, int bufferSize) {
        Objects.requireNonNull("asyncPredicate", "asyncPredicate is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"capacityHint");
        return new ObservableFilterAsync<T>(null, asyncPredicate, bufferSize);
    }
}

